using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;
using mshtml;
using System.Security;

namespace ProjectBoon.Win32
{
	#region IInternetSecurityManager

	[ComImport, Guid("79eac9ee-baf9-11ce-8c82-00aa004ba90b"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown), ComVisible(false)]
	public interface IInternetSecurityManager
	{
		[return: MarshalAs(UnmanagedType.I4)]
		[PreserveSig]
		int SetSecuritySite([In] IInternetSecurityMgrSite pSite);

		[return: MarshalAs(UnmanagedType.I4)]
		[PreserveSig]
		int GetSecuritySite([Out] IInternetSecurityMgrSite pSite);

		[return: MarshalAs(UnmanagedType.I4)]
		[PreserveSig]
		int MapUrlToZone([In, MarshalAs(UnmanagedType.LPWStr)] string pwszUrl, out int pdwZone, int dwFlags);

		[return: MarshalAs(UnmanagedType.I4)]
		[PreserveSig]
		int GetSecurityId([MarshalAs(UnmanagedType.LPWStr)] string pwszUrl, [MarshalAs(UnmanagedType.LPArray)] byte[] pbSecurityId, ref uint pcbSecurityId, uint dwReserved);

		[return: MarshalAs(UnmanagedType.I4)]
		[PreserveSig]
		int ProcessUrlAction([In, MarshalAs(UnmanagedType.LPWStr)] string pwszUrl, int dwAction, out byte pPolicy, int cbPolicy, byte pContext, int cbContext, int dwFlags, int dwReserved);

		[return: MarshalAs(UnmanagedType.I4)]
		[PreserveSig]
		int QueryCustomPolicy([In, MarshalAs(UnmanagedType.LPWStr)] string pwszUrl, ref Guid guidKey, byte ppPolicy, int pcbPolicy, byte pContext, int cbContext, int dwReserved);

		[return: MarshalAs(UnmanagedType.I4)]
		[PreserveSig]
		int SetZoneMapping(int dwZone, [In, MarshalAs(UnmanagedType.LPWStr)] string lpszPattern, int dwFlags);

		[return: MarshalAs(UnmanagedType.I4)]
		[PreserveSig]
		int GetZoneMappings(int dwZone, out System.Runtime.InteropServices.ComTypes.IEnumString ppenumString, int dwFlags);
	}
	[ComImport, Guid("79eac9ed-baf9-11ce-8c82-00aa004ba90b"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown), ComVisible(false)]
	public interface IInternetSecurityMgrSite
	{
		[return: MarshalAs(UnmanagedType.I4)]
		[PreserveSig]
		int GetWindow(out IntPtr hwnd);

		[return: MarshalAs(UnmanagedType.I4)]
		[PreserveSig]
		int EnableModeless([In, MarshalAs(UnmanagedType.Bool)] Boolean fEnable);
	}
	/// <summary>
	/// WebBrowserIInternetSecurityManagerT|[g񋟂IuWFNg擾邽߂̋@\`܂B
	/// </summary>
	[ComImport, Guid("6d5140c1-7436-11ce-8034-00aa006009fa"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IServiceProviderForIISM
	{
		[return: MarshalAs(UnmanagedType.I4)]
		[PreserveSig]
		int QueryService(
			[In] ref Guid guidService,
			[In] ref Guid riid,
			[MarshalAs(UnmanagedType.Interface)]out IInternetSecurityManager ppvObject);
	}

	#endregion
}
