using System;
using System.Runtime.InteropServices;

namespace ProjectBoon.Win32
{
	/// <summary>
	/// WindowsAPI
	/// </summary>
	public static class User32
	{

		#region Constant for User32

		public const int GWL_WNDPROC = -4;
		public const int GWL_HINSTANCE = -6;
		public const int GWL_USERDATA = -21;
		public const int GWL_HWNDPARENT = -8;

		public const uint GW_HWNDFIRST = 0;
		public const uint GW_HWNDLAST = 1;
		public const uint GW_HWNDNEXT = 2;
		public const uint GW_HWNDPREV = 3;
		public const uint GW_OWNER = 4;
		public const uint GW_CHILD = 5;

		#endregion

		#region Win32API :: User32

		[DllImport("user32.dll", CharSet = CharSet.Auto)]
		public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);
		[DllImport("user32.dll", CharSet = CharSet.Auto)]
		public static extern IntPtr FindWindowEx(IntPtr hWnd, IntPtr hwndChildAfter, string lpszClass, string lpszWindow);
		[DllImport("user32.dll", CharSet = CharSet.Auto)]
		public static extern IntPtr GetWindow(IntPtr hWnd, uint uCmd);

		[DllImport("user32.dll", CharSet = CharSet.Auto)]
		public static extern IntPtr SetWindowLong(IntPtr hWnd, int nIndex, IntPtr dwNewLong);
		[DllImport("user32.dll", CharSet = CharSet.Auto)]
		public static extern IntPtr GetWindowLong(IntPtr hWnd, int nIndex);
		[DllImport("user32.dll", CharSet = CharSet.Auto)]
		public static extern IntPtr CallWindowProc(IntPtr lpPrevWndFunc, IntPtr hWnd, int message, IntPtr wParam, IntPtr lParam);

		[DllImport("user32.dll", CharSet = CharSet.Auto)]
		public static extern uint ScreenToClient(IntPtr hWnd, ref POINT pt);

		#endregion

	}

}
