using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Net;
using System.Text;
using System.Threading;
using System.Text.RegularExpressions;
using System.Windows.Forms;

using Boon.Controls.Browsers;

using Boon.Collections;
using Boon.Net;
using Boon.IO.File;
using HttpService.API;
using HttpService.API.Request;
using Boon.Forms.Dialog;

using XmlSerializer = System.Xml.Serialization.XmlSerializer;
using XmlTextReader = System.Xml.XmlTextReader;
using XmlTextWriter = System.Xml.XmlTextWriter;


namespace Boon.Forms
{
    public partial class MainForm : Form
    {

        /// <summary>
        /// saveFolderTreeView܂B
        /// </summary>
        private void InitializeSaveFolderTreeView()
        {
            TreeNode tn1 = new TreeNode();
            TreeNode tn2 = new TreeNode();
            TreeNode tn3 = new TreeNode();
            tn1.Name = "downloadNode";
            tn1.Text = BoonDefine.DOWNLOAD_FOLDER_NAME;
            tn1.ImageIndex = 0;
            tn2.Name = "saveFolderNode";
            tn2.Text = BoonDefine.SAVE_FOLDER_NAME;
            tn2.ImageIndex = 1;
            tn2.SelectedImageIndex = 3;
            tn2.Tag = this.boonConfig_.saveFolderPath;
            tn3.Name = "searchFilesNode";
            tn3.Text = BoonDefine.SEARCH_FILES_NAME;
            tn3.ImageIndex = 2;

            try
            {
                if (("".Equals(boonConfig_.saveFolderPath)) || (!Directory.Exists(boonConfig_.saveFolderPath)))
                {
                    boonConfig_.saveFolderPath = Environment.GetFolderPath(Environment.SpecialFolder.Personal);
                }

                DirectoryInfo saveDirectoryInfo = new DirectoryInfo(this.boonConfig_.saveFolderPath);
                saveDirectoryInfo.Refresh();
                DirectoryInfo[] subDirInfo = saveDirectoryInfo.GetDirectories();

                foreach (DirectoryInfo di in subDirInfo)
                {
                    TreeNode tn = tn2.Nodes.Add(di.Name);
                    tn.Tag = di.FullName;
                    tn.ImageIndex = 1;
                    tn.SelectedImageIndex = 3;
                    DirectoryInfo[] subSubInfo = di.GetDirectories();
                    if (subSubInfo.Length > 0) tn.Nodes.Add("dummy");
                }
            }
            catch (DirectoryNotFoundException)
            {
                MessageBox.Show("ۑtH_܂B\nݒĂB");
            }

            this.saveFolderTreeView.Nodes.AddRange(new System.Windows.Forms.TreeNode[] { tn1, tn2, tn3 });

            this.saveFolderTreeView.SelectedNode = tn1;
            this.toggleListView(BoonDefine.DOWNLOAD_FOLDER_INDEX);

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveFolderTreeView_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            TreeNode selectedNode = this.saveFolderTreeView.GetNodeAt(e.X, e.Y);
            if (selectedNode == null) return;
            this.saveFolderTreeView.SelectedNode = selectedNode;

            if (e.Button == MouseButtons.Left)
            {
                this.toggleListView(this.getListKind(e.Node));
                if (e.Node.FullPath.StartsWith(BoonDefine.SAVE_FOLDER_NAME))
                {
                    this.updateSaveFolderListView((string)e.Node.Tag);

                }
                else if (e.Node.FullPath.StartsWith(BoonDefine.SEARCH_FILES_NAME)) // For Search Files
                {
                    SearchFileDialog dlg = new SearchFileDialog();
                    string pattern;
                    DirectoryInfo di = new DirectoryInfo(this.boonConfig_.saveFolderPath);
                    bool sub;
                    if (dlg.ShowSearchDialog(this, null, ref di, out pattern, out sub)
                        == DialogResult.OK)
                    {
                        FileInfo[] result = this.searchFileList(di, pattern, sub);
                        this.showSearchResult(result);
                    }
                    dlg.Dispose();
                }
            }
            else if (e.Button == MouseButtons.Right)
            {
                if (e.Node.FullPath.StartsWith(BoonDefine.DOWNLOAD_FOLDER_NAME))
                {
                    this.saveFolderTreeView.ContextMenuStrip = this.contextMenuStrip201_ForSaveTreeViewDownload;
                }
                else if (e.Node.FullPath.StartsWith(BoonDefine.SAVE_FOLDER_NAME))
                {
                    this.saveFolderTreeView.ContextMenuStrip = this.contextMenuStrip200_ForSaveTreeView;
                    if (e.Node.Text.Length != e.Node.FullPath.Length)
                    {
                        this.contextMenuStrip200_ForSaveTreeView.Items[1].Visible = true;
                        this.contextMenuStrip200_ForSaveTreeView.Items[2].Visible = true;
                    }
                    else
                    {
                        this.contextMenuStrip200_ForSaveTreeView.Items[1].Visible = false;
                        this.contextMenuStrip200_ForSaveTreeView.Items[2].Visible = false;
                    }
                }
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveDirectryTreeView_NodeMouseDoubleClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            switch (e.Node.Index)
            {
                case BoonDefine.DOWNLOAD_FOLDER_INDEX:
                    break;

                case BoonDefine.SAVE_FOLDER_INDEX:
                    break;

                default:
                    break;
            }

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="n"></param>
        /// <returns></returns>
        private int getListKind(TreeNode n)
        {
            if (n.FullPath.Equals(BoonDefine.DOWNLOAD_FOLDER_NAME))
            {
                return (BoonDefine.DOWNLOAD_FOLDER_INDEX);
            }
            else if (n.FullPath.StartsWith(BoonDefine.SAVE_FOLDER_NAME))
            {
                return (BoonDefine.SAVE_FOLDER_INDEX);
            }
            else if (n.FullPath.Equals(BoonDefine.SEARCH_FILES_NAME))
            {
                return (BoonDefine.SEARCH_FILES_INDEX);
            }

            return (-1);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveFolderTreeView_DragEnter(object sender, DragEventArgs e)
        {
            Debug.WriteLine("hoge");
            if (e.Data.GetDataPresent("videoPath"))
            {
                Debug.WriteLine("fuga");
                e.Effect = (e.AllowedEffect & DragDropEffects.Move);
            }

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveFolderTreeView_ItemDrag(object sender, ItemDragEventArgs e)
        {
            TreeView tv = (TreeView)sender;
            tv.SelectedNode = (TreeNode)e.Item;
            tv.Focus();

            DragDropEffects dde = tv.DoDragDrop(e.Item, DragDropEffects.Move | DragDropEffects.Copy);
            if ((dde & DragDropEffects.Move) == DragDropEffects.Move)
            {
                //tv.Nodes.Remove((TreeNode)e.Item);
                Debug.WriteLine(((TreeNode)e.Item).Tag.ToString() + " is removed.");
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveFolderTreeView_DragOver(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(typeof(TreeNode)))
            {
                if (((e.KeyState & 0x08) > 0) && ((e.AllowedEffect & DragDropEffects.Copy) == DragDropEffects.Copy))
                {
                    e.Effect = DragDropEffects.Copy;
                }
                else if ((e.AllowedEffect & DragDropEffects.Move) == DragDropEffects.Move)
                {
                    e.Effect = DragDropEffects.Move;
                }
                else
                {
                    e.Effect = DragDropEffects.None;
                }
            }
            else
            {
                e.Effect = DragDropEffects.None;
            }
            
            if (e.Effect != DragDropEffects.None)
            {
                TreeView tv = (TreeView)sender;
                TreeNode targetNode = tv.GetNodeAt(tv.PointToClient(new Point(e.X, e.Y)));
                TreeNode sourceNode = (TreeNode)e.Data.GetData(typeof(TreeNode));

                if ((targetNode != null) && (targetNode != sourceNode) && (!IsChildNode(sourceNode, targetNode)))
                {
                    if (!targetNode.IsSelected)
                    {
                        tv.SelectedNode = targetNode;
                    }
                }
                else
                {
                    e.Effect = DragDropEffects.None;
                }
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveFolderTreeView_BeforeExpand(object sender, TreeViewCancelEventArgs e)
        {
            TreeNode selectedNode = e.Node;
            selectedNode.Nodes.Clear();

            DirectoryInfo selectedDir = new DirectoryInfo(selectedNode.Tag.ToString());

            if (selectedDir.Exists)
            {
                DirectoryInfo[] subDirInfo = selectedDir.GetDirectories();

                foreach (DirectoryInfo di in subDirInfo)
                {
                    try
                    {
                        TreeNode tn = selectedNode.Nodes.Add(di.Name);
                        tn.Tag = di.FullName;
                        tn.ImageIndex = 1;
                        tn.SelectedImageIndex = 3;

                        DirectoryInfo[] subSubInfo = di.GetDirectories();
                        if (subSubInfo.Length > 0) tn.Nodes.Add("dummy");
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show("G[F" + ex.Message.ToString());
                    }
                }
            }
            else
            {
                MessageBox.Show("IꂽtH_݂Ă܂B");
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="parent"></param>
        /// <param name="child"></param>
        /// <returns></returns>
        private static bool IsChildNode(TreeNode parent, TreeNode child)
        {
            if (child.Parent == parent)
            {
                return (true);
            }
            else if (child.Parent != null)
            {
                return (IsChildNode(parent, child.Parent));
            }

            return (false);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveFolderTreeView_DragDrop(object sender, DragEventArgs e)
        {
            Debug.WriteLine(e.Data.GetData("videoPath"));
            if (e.Data.GetDataPresent(typeof(ListView)))
            {
                ListView.SelectedListViewItemCollection list = ((ListView)e.Data.GetData(DataFormats.FileDrop)).SelectedItems;

                foreach (ListViewItem lvi in list)
                {
                    VideoFileData vfd = (VideoFileData)lvi.Tag;
                    Debug.WriteLine(vfd.videoFilePath);
                    Debug.WriteLine(vfd.fileUrl);
                }
            }
            else if (e.Data.GetDataPresent(typeof(TreeNode)))
            {
                TreeView tv = (TreeView)sender;
                TreeNode sourceNode = (TreeNode)e.Data.GetData(typeof(TreeNode));
                TreeNode targetNode = tv.GetNodeAt(tv.PointToClient(new Point(e.X, e.Y)));

                if ((targetNode != null) && (sourceNode != targetNode) && (!IsChildNode(sourceNode, targetNode)))
                {
                    TreeNode cln = (TreeNode)sourceNode.Clone();
                    targetNode.Nodes.Add(cln);
                    targetNode.Expand();
                    tv.SelectedNode = cln;

                    Debug.WriteLine("source:" + sourceNode.Tag.ToString());
                    Debug.WriteLine("target:" + targetNode.Tag.ToString());
                }
                else
                {
                    e.Effect = DragDropEffects.None;
                }
            }
            else
            {
                e.Effect = DragDropEffects.None;
            }

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveFolderTreeView_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                ((TreeView)sender).SelectedNode = ((TreeView)sender).GetNodeAt(e.X, e.Y);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveFolderTreeView_MouseUp(object sender, MouseEventArgs e)
        {

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void saveFolderTreeView_AfterLabelEdit(object sender, NodeLabelEditEventArgs e)
        {
            // rootm[h͕ύXs
            if (e.Node.Parent == null)
            {
                e.CancelEdit = true;
                return;
            }
            string parentPath = (string)e.Node.Parent.Tag;
            string destPath = parentPath + @"\" + e.Label;

            if (e.Label.IndexOf(@"\") != -1)
            {
                e.CancelEdit = true;
                return;
            }

            if (Directory.Exists(destPath))
            {
                e.CancelEdit = true;
                return;
            }

            try
            {
                Directory.Move(e.Node.Tag.ToString(), destPath);
            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.Message.ToString());
                e.CancelEdit = true;
                return;
            }
        }

    }
}
