using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Net;
using System.Text;
using System.Threading;
using System.Text.RegularExpressions;
using System.Windows.Forms;

using Boon.Controls.Browsers;

using Boon.Collections;
using Boon.Net;
using Boon.IO.File;
using HttpService.API;
using HttpService.API.Request;
using Boon.Forms.Dialog;
using Boon.Functions;

namespace Boon.Forms
{
    public partial class MainForm : Form
    {
        #region TabBrowserControl֘A

		#region +---- EventHandlers

		/// <summary>
        /// _E[hNꂽۂ̃CxgłB
        /// DownloadListViewListViewItemǉ܂B
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێMovieDownloadRequiredEventArgsIuWFNg</param>
        private void tabBrowser_MovieDownloadRequired(object sender, MovieDownloadRequiredEventArgs e)
        {
			if(e.ChangeTitle)
			{
			}
            this.setDownloadReservation(e.Url);
        }

        private void tabBrowser_TbNavigated(object sender, WebBrowserNavigatedEventArgs e)
        {
            ITbPageControl page = sender as ITbPageControl;
            if (page != null && page.DisplayUrl == e.Url.ToString())
            {
                string stitle = page.DisplayTitle;
                string surl = e.Url.AbsoluteUri;
                if (stitle == String.Empty) stitle = surl;
                this.history_Add(stitle, surl);
            }
        }

        private void tabBrowser_TbDisplayTitleChanged(ITbPageControl sender, ITbDisplayEventArgs e)
        {
            this.Text = appTitle + " - " + this.tabBrowser.TbTitle;
        }
        private void tabBrowser_TbDisplayUrlChanged(ITbPageControl sender, ITbDisplayEventArgs e)
        {
            if (!this.toolStripTextBoxUrl.Focused)
                this.toolStripTextBoxUrl.Text = this.tabBrowser.TbUrl;
			
			this.toolStripButton9_download.Enabled = BoonCommon.Regex_UrlIsNicoWatchPage.IsMatch(this.tabBrowser.TbUrl);
        }
        private void tabBrowser_TbDisplayStatusTextChanged(ITbPageControl sender, ITbDisplayEventArgs e)
        {
        }

        private void tabBrowser_TbCanGoBackChanged(object sender, EventArgs e)
        {
            this.toolStripButton01_back.Enabled = this.tabBrowser.TbCanGoBack;
        }
        private void tabBrowser_TbCanGoForwardChanged(object sender, EventArgs e)
        {
            this.toolStripButton02_forward.Enabled = this.tabBrowser.TbCanGoForward;
        }

        private void tabBrowser_TbSelectedIndexChanged(object sender, EventArgs e)
        {
            this.toolStripTextBoxUrl.Text = this.tabBrowser.TbUrl;
            this.Text = appTitle + " - " + this.tabBrowser.TbTitle;
            this.toolStripButton01_back.Enabled = this.tabBrowser.TbCanGoBack;
			this.toolStripButton02_forward.Enabled = this.tabBrowser.TbCanGoForward;
			this.toolStripButton9_download.Enabled = BoonCommon.Regex_UrlIsNicoWatchPage.IsMatch(this.tabBrowser.TbUrl);
		}

		#endregion

		/// <summary>
		/// uEȖJڂs܂B
		/// </summary>
		/// <param name="URL">JڐURL</param>
		private void Navigate(string URL)
		{
			Uri u = null;
			if(Uri.TryCreate(URL, UriKind.Absolute, out u))
			{
				this.tabBrowser.TbNavigate(u);
			}
			else { MessageBox.Show("URL܂"); }
		}

		private void Navigate(string url, bool opennew)
		{
			if(opennew)
			{
				this.tabBrowser.TbOpenNewTab(url, this.tabBrowser.TbSelectedIndex + 1, true);
			}
			else
			{
				Uri u = null;
				if(Uri.TryCreate(url, UriKind.Absolute, out u))
					this.tabBrowser.TbNavigate(u, true);
				else
					MessageBox.Show(String.Format("URĽ`sł\n> {0}", url));
			}
		}

		#endregion

		#region FavoriteTreeView֘A

		/// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnAddFavorite_Click(object sender, EventArgs e)
        {
            if (this.tabBrowser.TbSelectedBrowser != null)
            {
                string title = this.tabBrowser.TbSelectedBrowser.DocumentTitle;
                string url = this.tabBrowser.TbSelectedBrowser.Url;
                this.favoriteTreeView1.FvAddPageCustom(title, url, String.Empty);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void favoriteTreeView1_FvNavigateRequired(object sender, Boon.Functions.NavigateRequiredEventArgs e)// Add 080830 - BaseVer0.0.10
        {
			if(this.InvokeRequired)
			{
				this.Invoke((MethodInvoker)delegate { this.Navigate(e.Url, e.OpenNew); });
			}
			else
			{
				this.Navigate(e.Url, e.OpenNew);
			}
        }



        #endregion

        #region  SidePanel֘A(EventHandler)

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void tabSideBar_SelectedIndexChanged(object sender, EventArgs e)
        {
            int selindex = this.tabSideBar.SelectedIndex;
            if (selindex == 0)
            {
                this.toolStripButton6_favorite.Checked = true;
                this.toolStripButton7_history.Checked = false;
                this.btnAddFavorite.Visible = true;
                this.btnAddFavorite.Enabled = true;
            }
            else if (selindex == 1)
            {
                toolStripButton6_favorite.Checked = false;
                this.toolStripButton7_history.Checked = true;
                this.btnAddFavorite.Visible = false;
                this.btnAddFavorite.Enabled = false;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void splitContainerBrowsSidebar_SplitterMoved(object sender, SplitterEventArgs e)
        {
            this.btnAddFavorite.Left = e.SplitX - this.btnAddFavorite.Width;
            this.tabSideBar.Width = e.SplitX + 4;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void tabSideBar_SizeChanged(object sender, EventArgs e)
        {
            this.favoriteTreeView1.Height = this.tabSideBar.Height - 27;
            this.favoriteTreeView1.Width = this.tabSideBar.Width - 7;
        }



		#region ֘A

		/// <summary>
		/// ̍őێ
		/// </summary>
        int history_max_count = 10;

        private void history_Add(string title, string url)
        {
            while (this.listHistory.Items.Count >= history_max_count)
            {
                this.listHistory.Items.RemoveAt(this.listHistory.Items.Count - 1);
            }
            ListViewItem item = new ListViewItem();
            item.Text = title;
            item.Tag = (object)url;
            item.ToolTipText = title + "\n" + url;
            this.listHistory.Items.Insert(0, item);
        }
        private string history_Get(int entry) // Add 080830 - BaseVer0.0.10
        {
            if (0 <= entry && entry < this.listHistory.Items.Count)
            {
                return (string)this.listHistory.Items[entry].Tag;
            }
            else return string.Empty;
        }
        private bool history_Remove(int entry) // Add 080830 - BaseVer0.0.10
        {
            if (0 <= entry && entry < this.listHistory.Items.Count)
            {
                this.listHistory.Items.RemoveAt(entry);
                return true;
            }
            return false;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listHistory_ItemActivate(object sender, EventArgs e)
        {
            if (this.listHistory.FocusedItem.Tag != null)
            {
                string url = (string)this.listHistory.FocusedItem.Tag;
                this.listHistory.Items.Remove(this.listHistory.FocusedItem);
                Uri u = null;
                if (Uri.TryCreate(url, UriKind.Absolute, out u))
                {
                    this.tabBrowser.TbNavigate(u);
                }
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listHistory_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Middle)
            {
                ListViewItem item = this.listHistory.GetItemAt(e.X, e.Y);
                if (item != null)
                {
                    if (item.Bounds.Contains(e.Location))
                    {
                        string url = (string)item.Tag;
                        this.tabBrowser.TbOpenNewTab(url, this.tabBrowser.TbSelectedIndex + 1, true);
                    }
                }
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listHistory_SizeChanged(object sender, EventArgs e)
        {
            // ȂȂƃoOB
            this.listHistoryClmn_Title.Width = this.listHistory.Width - 10;
            this.listHistoryClmn_Title.Width = this.listHistory.Width - 5;
        }

		#endregion

        #endregion


        #region t@Cp

        private FileInfo[] searchFileList(DirectoryInfo dir, string pattern, bool subfolder)
        {
            if (dir != null)
            {
                List<FileInfo> files = new List<FileInfo>(64);
                string ptn = "*" + pattern + "*";
                FileInfo[] fi = dir.GetFiles(ptn);
                files.AddRange(fi);
                if (subfolder)
                {
                    this.searchfilelist_routine(files, dir.GetDirectories(), ptn);
                }
                return files.ToArray();
            }
            else { return new FileInfo[0]; }
        }
        private void searchfilelist_routine(List<FileInfo> target, DirectoryInfo[] dirs, string pattern)
        {
            for (int i = 0; i < dirs.Length; ++i)
            {
                FileInfo[] fi = dirs[i].GetFiles(pattern);
                target.AddRange(fi);
                this.searchfilelist_routine(target, dirs[i].GetDirectories(), pattern);
            }
        }

        private void showSearchResult(FileInfo[] result)
        {
            Regex rx_extension = new Regex("^\\.(flv|mp4|swf)$");
            this.toggleListView(BoonDefine.SEARCH_FILES_INDEX);
            List<ListViewItem> items = new List<ListViewItem>();
            for (int i = 0; i < result.Length; ++i)
            {
                if (rx_extension.IsMatch(result[i].Extension))
                {
                    float size = Convert.ToSingle(result[i].Length);
                    items.Add(new ListViewItem(new string[]{
						result[i].Name, 
						String.Format("{0:F3}",size / 1000000F),
						result[i].LastWriteTime.ToString(),
						result[i].Extension,
						result[i].FullName
					}));
                }
            }
            this.SearchResultListView.Items.AddRange(items.ToArray());
        }

        #endregion


		#region Download@\Ăяo

		/// <summary>
        /// 
        /// </summary>
        /// <param name="queryUrl"></param>
        private void setDownloadReservation(string queryUrl)
        {
            VideoFileData vfd = this.getLinkData(queryUrl);

            if (vfd == null)
            {
                MessageBox.Show("p[^G[łB\nurl=[" + queryUrl + "]");
                return;
            }

            if (!this.downloadListView.Items.ContainsKey(vfd.videoID))
            {
                vfd.registeredTime = DateTime.Now.Ticks;
                vfd.videoFileStatus = VideoFileData.DOWNLOAD_WAITING;

                ListViewItem lvi =
                    new ListViewItem
                    (
                        new string[]
                        {
                            vfd.videoTitle,
                            vfd.GetStatusMessage(),
                            "",
                            "",
                            "",
                            "",
                            "",
                            "",
                            new DateTime(vfd.registeredTime).ToString("yyyy/MM/dd HH:mm:ss"),
                        }
                    );
                lvi.Name = vfd.videoID;
                lvi.Tag = vfd;
                this.downloadListView.Items.Add(lvi);
                this.Refresh();

                BoonDownloadManager.addReservation(vfd.videoID, lvi, false);
            }

        }

        /// <summary>
        /// _E[hNp̃N𐶐܂B
        /// </summary>
        /// <param name="url">_E[hN쐬錳URL</param>
        /// <param name="title">_E[hN쐬錳̃^Cg</param>
        /// <returns>_E[hNpN</returns>
        private string getBoonLinkString(string url, string title)
        {
            Regex regex = new Regex(@"^(http://www.nicovideo.jp/)?watch/([a-zA-Z0-9]+)$");
            Match match = regex.Match(url);

            if (match.Success)
            {
                return ("http://boon?url=" + System.Web.HttpUtility.UrlEncode(url)
                    + "&title=" + System.Web.HttpUtility.UrlEncode(title)
                    + "&videoID=" + System.Web.HttpUtility.UrlEncode(match.Groups[2].ToString()));
            }
            return ("");
        }

        /// <summary>
        /// p[^񂩂Ap[^o܂B
        /// </summary>
        /// <param name="parameter"></param>
        /// <returns>op[^i[VideoFileDataIuWFNg</returns>
        VideoFileData getLinkData(string parameter)
        {
            Dictionary<string, string> datas = HttpService.Core.ParseUrlValues(parameter);

            if (!datas.ContainsKey("videoID")) return (null);

            if ("".Equals(datas["videoID"])) return (null);

            if ((!datas.ContainsKey("title")) || ("".Equals(datas["title"]))) return (new VideoFileData(datas["videoID"]));

            return (new VideoFileData(datas["videoID"], datas["title"]));
        }


		#endregion

	}
}
