
/* ------------------------
MathMatrix.js
*/

/* ====================
** 行列
*/
function MathMatrix(par) {
    //this.wrap = par;
    this.obj = document.createElement('table');
    this.__super__(par);
    this.obj.className = 'MathMatrix';
    this.mrs = new Array;
    this.ths = new Array;
    this.tds = new Array;
    this.rowcount = 2;
    this.colcount = 2;
    for(var row = 0; row < this.rowcount; row++) {
        this.mrs[row] = new Array;
        this.tds[row]= new Array;
        this.ths[row] = this.obj.insertRow(row);
        for(var col = 0; col < this.colcount; col++) {
            this.mrs[row][col] = new MathRow(this, this.wrap.level);
            this.mrs[row][col].obj.className += ' inMathMatrix';
            this.tds[row][col] = this.ths[row].insertCell(col);
            this.tds[row][col].appendChild(this.mrs[row][col].obj);
        }
    }
    this._layout();
}

BUtil.inherit(MathMatrix, BExpItem);

BUtil.setProperty(MathMatrix, {
			objType: 'matrix'
		    });

ContainerButtons.submit(61, 'matrix', function(wrap){return new MathMatrix(wrap);});

// 初期の内容を決める
MathMatrix.prototype.setInitialValue = function(val) {
    this.mrs[0][0].setInitialValue(val);
}

// 前のブロックにカーソルを移動
MathMatrix.prototype.backCursor = function(bid) {
    if(bid == this.mrs[0][0].obj.id) {
        this.wrap.backCursor(this.obj.id);
    }
    else {
        for(var i = 1; i < this.rowcount * this.colcount; i++) {
            if(bid == this.mrs[Math.floor(i / this.rowcount)][i % this.rowcount].obj.id) {
                i--;
                this.mrs[Math.floor(i / this.rowcount)][i % this.rowcount].setCursor(-1);
                return;
            }
        }
    }
}

// 次のブロックにカーソルを移動
MathMatrix.prototype.fwdCursor = function(bid) {
    if(bid == this.mrs[this.rowcount - 1][this.colcount - 1].obj.id) {
        this.wrap.fwdCursor(this.obj.id);
    }
    else {
        for(var i = 0; i < this.rowcount * this.colcount - 1; i++) {
            if(bid == this.mrs[Math.floor(i / this.rowcount)][i % this.rowcount].obj.id) {
                i++;
                this.mrs[Math.floor(i / this.rowcount)][i % this.rowcount].setCursor(0);
                return;
            }
        }
    }
}

// 端にカーソルを置く
MathMatrix.prototype.setCursor = function(num) {
    if(num == 0) {
        this.mrs[0][0].setCursor(0);
    }
    else if(num == -1) {
        this.mrs[this.rowcount - 1][this.colcount - 1].setCursor(-1);
    }
}

// MathMLコード書き出し
MathMatrix.prototype.outputMathML = function(expand) {
    var ret = '<mtable>' + "\n";
    for(var row = 0; row < this.rowcount; row++) {
        ret += '<mtr>' + "\n";
        for(var col = 0; col < this.colcount; col++) {
            ret += '<mtd>' + "\n";
            ret += this.mrs[row][col].outputMathML(expand);
            ret += '</mtd>' + "\n";
        }
        ret += '</mtr>' + "\n";
    }
    ret += '</mtable>' + "\n";
    return ret;
}

// LaTeXコード書き出し
MathMatrix.prototype.outputLatex = function() {
    var ret = Const.backslash + 'begin{array}{' + 'cccccccccc'.substring(0, this.colcount) + '}' + "\n";
    for(var row = 0; row < this.rowcount; row++) {
        for(var col = 0; col < this.colcount - 1; col++) {
            ret += this.mrs[row][col].outputLatex() + ' & ';
        }
        ret += this.mrs[row][col].outputLatex();
        if(row < this.rowcount){
            ret +=  Const.backslash + Const.backslash + "\n";
        }
    }
    ret += Const.backslash + 'end{array}' + "\n";
    return ret;
}

// 表示部品削除
MathMatrix.prototype.removeObj = function() {
    for(var row = 0; row < this.rowcount; row++) {
        for(var col = 0; col < this.colcount; col++) {
            this.mrs[row][col].removeObj();
            this.ths[row].deleteCell(0);
        }
        this.obj.deleteRow(0);
    }
    this.obj.parentNode.removeChild(this.obj);
}

// コンテナ内配置
MathMatrix.prototype._layout = function() {
    this.width = 0;
    this.height = 0;
    var roww = new Array;
    var colh = 0;
    var mr;
    for(var col = 0; col < this.colcount; col++) {
        roww[col] = 0;
    }
    for(var row = 0; row < this.rowcount; row++) {
        colh = 0;
        for(var col = 0; col < this.colcount; col++) {
            mr = this.mrs[row][col].getPreferredSize();
            colh = Math.max(mr.height, colh);
            roww[col] = Math.max(mr.width, roww[col]);
        }
        this.height += colh;
    }
    for(var col = 0; col < this.colcount; col++) {
        this.width += roww[col];
    }
    this.width += this.colcount + 1;
    this.height += this.rowcount + 1;
    this.top = Math.floor(this.height / 2);
    this.bottom = Math.ceil(this.height / 2);
}





