
/* ------------------------
Symbol.js
*/

/* ====================
** 実体参照シンボルが書いてある画像かテキストノードを格納したspan
*/
function BSymbol(wrap, tid, fixsize) {
    this.id = tid;
    this.level = wrap.level;
    this.obj = document.createElement('span');
    this.obj.className = 'symbol ' + ((this.level == 1) ? 'level1' : 'level2');
    if(Config.isMML) {
        this.expand = BSymbol.all[this.id].code;
        this.node = document.createTextNode(this.expand);
        this.obj.appendChild(this.node);
        this.width = Const.tokenWidth[this.level];
        this.height = Const.tokenHeight[this.level];
    }
    else {
        this.tex = BSymbol.all[this.id].tex;
        this.node = document.createElement('img');
        var simg = BSymbol.all[this.id].img[this.level];
        this.node.src = simg.obj.src;
        if(fixsize) {
            var s = Const.tokenHeight[this.level] - 2;
            this.node.width = Math.min(simg.width, s-2);
            this.node.height = Math.min(simg.height, s-2);
            this.node.hspace = Math.floor((s - this.node.width) / 2);
            this.node.vspace = Math.floor((s - this.node.height) / 2);
        }
        else {
            this.width = simg.width;
            this.height = simg.height;
        }
        this.obj.appendChild(this.node);
    }
}

// 必要サイズ応答
BSymbol.prototype.getPreferredSize = function() {
    return {
        top: this.height / 2,
        bottom: this.height / 2,
        height: this.height,
        width: this.width
    };
}

BSymbol.prototype.removeObj = function() {
    if(!Config.isMML) {
        this.obj.removeChild(this.node);
    }
    this.obj.parentNode.removeChild(this.obj);
}

BSymbol.prototype.getMathML = function(expand) {
    var mml = (BSymbol.all[this.id].mathml) ? (BSymbol.all[this.id].mathml) : this.id;
    return (expand) ? (BSymbol.all[this.id].code) : ('&' + mml + ';');
}

BSymbol.prototype.getLatex = function() {
    return Const.backslash + BSymbol.all[this.id].tex;
}

// クラス変数
BSymbol.operators = {
sdot: {code: '\u22c5', tex: 'cdot'},
    times: {code: '\u00d7', tex: 'times'},
divide: {code: '\u00f7', tex: 'div'},
PlusMinus: {code: '\u00b1', tex: 'pm'},
MinusPlus: {code: '\u2213', tex: 'mp'},
NotEqual: {code: '\u2260', tex: 'neq'},
//efDot: {code: '\u2252', tex: ''},
lE: {code: '\u2266', tex: 'leq'},
gE: {code: '\u2267', tex: 'geq'},
sub: {code: '\u2282', tex: 'subset'},
sup: {code: '\u2283', tex: 'supset'},
sube: {code: '\u2286', tex: 'subseteq'},
supe: {code: '\u2287', tex: 'supseteq'},
isin: {code: '\u2208', tex: 'in'},
ni: {code: '\u220b', tex: 'ni'},
cup: {code: '\u222a', tex: 'cup'},
cap: {code: '\u2229', tex: 'cap'},
larr: {code: '\u2190', tex: 'leftarrow'},
rarr: {code: '\u2192', tex: 'rightarrow'},
lArr: {code: '\u21d0', tex: 'Leftarrow'},
rArr: {code: '\u21d2', tex: 'Rightarrow'},
hArr: {code: '\u21d4', tex: 'Leftrightarrow'},
compfn: {code: '\u2218', tex: 'circ'},
ctdot: {code: '\u22ef', tex: 'cdots'},
equiv: {code: '\u2261', tex: 'equiv'},
//bsim: {code: '\u223d', tex: ''},
perp: {code: '\u22a5', tex: 'perp'}
};

BSymbol.identifiers = {
alpha: {code: '\u03b1', tex: 'alpha'},
beta: {code: '\u03b2', tex: 'beta'},
delta: {code: '\u03b4', tex: 'delta'},
epsiv: {code: '\u025b', tex: 'varepsilon'},
gamma: {code: '\u03b3', tex: 'gamma'},
omega: {code: '\u03c9', tex: 'omega'},
phi: {code: '\u03c6', tex: 'phi'},
phiv: {code: '\u03d5', tex: 'varphi'},
theta: {code: '\u03b8', tex: 'theta'},
Delta: {code: '\u0394', tex: 'Delta'},
pi: {code: '\u03c0', tex: 'pi'},
infin: {code: '\u221e', tex: 'infty'},
bigtriangleup: {code: '\u25b3', tex: 'bigtriangleup'}
//angle: {code: '\u2220', tex: ''},
//deg: {code: '\u00b0', tex: ''}
};

BSymbol.parts = {
OverBar: {code: '\u00af', tex: ''},
sum: {code: '\u2211', tex: 'sum'},
    mathint: {code: '\u222b', tex: 'int', mathml: 'int'}
};

BSymbol.groups = [BSymbol.operators, BSymbol.identifiers, BSymbol.parts];

BSymbol.all = new Object();

BSymbol.observer = new BUtil.Observer();

BSymbol.loadedNumber = 0;
BSymbol.initialized = false;

// クラス変数とか初期化
BSymbol.initialize = function(bredima) {
    // BSymbol.all連想配列作成
    BSymbol.allLength = 0;
    for(var i = 0; i < BSymbol.groups.length; i++) {
	for(var p in BSymbol.groups[i]) {
	    BSymbol.all[p] = BSymbol.groups[i][p];
	    BSymbol.allLength++;
	}
    }

    // 画像先読み
    for(var s in BSymbol.all) {
        BSymbol.all[s].img = new Array();
        for(var size = 1; size <= 2; size++) {
	    var t = new Object();
	    t.obj = new Image();
	    t.obj.onload = BSymbol._initOnLoad;
	    t.obj.src = bredima.mimetex.getURI(BUtil.Const.backslash + BSymbol.all[s].tex, size);
	    BSymbol.all[s].img[size] = t;
	}
    }
}

// 画像先読み完了で画像サイズを登録
BSymbol._initOnLoad = function() {
    if(++BSymbol.loadedNumber == BSymbol.allLength * 2) {
	for(var p in BSymbol.all) {
	    for(var size = 1; size <= 2; size++) {
		var t = BSymbol.all[p].img[size];
		t.width = t.obj.width;
		t.height = t.obj.height;
	    }
	}
	BSymbol.initialized = true;
	BSymbol.observer.notify('load');
    }
}

BUtil.style.add(
    [['span.symbol', 'position: absolute'],
     ['div.symbol', 'position: absolute; text-align: center;'],
     ['div.symbol span.symbol', 'position: static']]
);
