
/* ------------------------
Token.js
-- トークンオブジェクト

*Token - 抽象クラス
*MathSymbol - 実体参照文字
*MathString - sin, cos, ...
*/

/* ====================
** トークンオブジェクト抽象クラス
*/
function BExpToken(par) {
    this.obj = document.createElement('div');
    BExpToken.superClass.apply(this, arguments);
    this.obj.className = 'Token';
}

BUtil.inherit(BExpToken, BExpItem);

BExpToken.width = [0, 10, 7];
BExpToken.height = [0, 22, 18];

// 初期の内容は入らないので破棄する
BExpToken.prototype.setInitialValue = function(val) {
    this.wrap.layout();
    this.wrap.fwdCursor(this.obj.id);
}

// 端にカーソルを置く ことはできないので隣へ移動
BExpToken.prototype.setCursor = function(num) {
    if(num == 0) {
        this.wrap.fwdCursor(this.obj.id);
    }
    else if(num == -1) {
        this.wrap.backCursor(this.obj.id);
    }
}

// 必要サイズ応答
BExpToken.prototype.getPreferredSize = function() {
    return {
        top: this.height / 2,
        bottom: this.height / 2,
        height: this.height,
        width: this.width
    };
}

// MathMLコード書き出し
BExpToken.prototype.outputMathML = function(expand) {
    return this._tagMML(this.value);
}

// 表示部品削除
BExpToken.prototype.removeObj = function() {
    this.obj.parentNode.removeChild(this.obj);
}

// ----------private
// MathMLコード書き出し
BExpToken.prototype._tagMML = function(content) {
    var tag = (this.tagType == 'identifier') ? 'mi' : 'mo';
    var out = '<' + tag + '>';
    out += content;
    out += '</' + tag + '>';
    return out;
}


/* ====================
** 実体参照シンボル
*/
function MathSymbol(par, tid, tagtype) {
    this.__super__(par);
    this.id = tid;
    this.tagType = tagtype;
    this.level = this.wrap.level;
    this.obj.className += ' math_symbol';
    this.content = new BSymbol(this, this.id, true);
    this.obj.appendChild(this.content.obj);
    this.width = this.height = Const.tokenHeight[this.level];
    //this.top = this.bottom = this.height / 2;
    this._setSize();
}

BUtil.inherit(MathSymbol, BExpToken);

BUtil.setProperty(MathSymbol, {
    objType: 'symbol'
});

// MathMLコード書き出し
MathSymbol.prototype.outputMathML = function(expand) {
    return this._tagMML(this.content.getMathML(expand));
}

// LaTeXコード書き出し
MathSymbol.prototype.outputLatex = function() {
    return this.content.getLatex();
}

/* ====================
** 関数とか
*/
function MathString(par, val) {
    this.__super__(par);
    this.value = val;
    this.level = this.wrap.level;
    this.content = new StringSpan(this, this.value);
    this.obj.appendChild(this.content.obj);
    
    // レイアウト
    this.width = this.content.width;
    this.height = this.content.height;
    this._setSize();
}

BUtil.inherit(MathString, BExpToken);

BUtil.setProperty(MathString, {
    objType: 'string',
    tagType: 'identifier'
});

// LaTeXコード書き出し
MathString.prototype.outputLatex = function() {
    return Const.backslash + this.value;
}



