
/* ------------------------
Util.js
-- ユーティリティ関数いろいろ

*BUtil - あると便利なクラス関数群
*/

BUtil = function(){};

/* ====================
** ルート
*/

/* 定数 */
BUtil.Const = {
    'version' : '0.4.0070810',
    'backslash' : '\\',
    'tokenWidth' : [0, 10, 7],
    'tokenHeight' : [0, 22, 18]
};

/* キーコード */
BUtil.key = {
    'bs' : 8,
    'left' : 37,
    'up' : 38,
    'right' : 39,
    'down' : 40
};

/* ====================
** ルート関数
*/

/* 継承 */
BUtil.inherit = function(sub, sp) {
    function tmp() {};
    tmp.prototype = sp.prototype;
    sub.prototype = new tmp();
    sub.prototype.__super__ = sp;
    sub.superClass = sp;
    sub.prototype.constructor = sub;
}

/* クラスのプロトタイプ属性を設定 */
BUtil.setProperty = function(c, props) {
    for(var key in props) {
	c.prototype[key] = props[key];
    }
}

/* ====================
** 関数をまとめたオブジェクト
*/
/* イベント関係を便利に */
BUtil.event = new Object();

BUtil.event.stop = function(evt) {
    if(evt && evt.preventDefault) {
	evt.preventDefault();
    }
    else if(window.event) {
	window.event.returnValue = false;
    }
    
    if(evt && evt.stopPropagation) {
	evt.stopPropagation();
    }
    else if(window.event) {
	window.event.cancelBubble = true;
    }
}

/* DOMオブジェクト系の関数 */
BUtil.obj = new Object();

BUtil.obj.setSize = function(obj, width, height) {
    obj.style.width = width + 'px';
    obj.style.height = height + 'px';
}

BUtil.obj.setPos = function(obj, left, top) {
    obj.style.left = left + 'px';
    obj.style.top = top + 'px';
}

/* CSS */
BUtil.style = new Object();
BUtil.style.str = '';

BUtil.style.add = function(styles) {
    for( var i = 0; i < styles.length; i++) {
	var s = styles[i];
	var a = new Array();
	for(var n = 0; n < s.length - 1; n++) {
	    a[n] = 'div.BrEdiMa_Frame ' + s[n];
	}
	BUtil.style.str += a.join(',') + '{' + s[s.length - 1] + '} ';
    }
}

BUtil.style.addStylesheet = function() {
    var head = document.getElementsByTagName('head')[0];
    if(!head) return;
    var style = document.createElement('style');
    if(typeof(style.styleSheet) == 'object') { // IE
	style.type = 'text/css';
	style.styleSheet.cssText = BUtil.style.str;
    }
    else { // それ以外
	style = document.createElement('link');
	style.rel = 'stylesheet';
	style.href = 'data:text/css,' + escape(BUtil.style.str);
    }
    head.appendChild(style);
}

/* ====================
** クラス
*/

/* Observerパターンをインスタンスに追加 */
BUtil.Observer = function() {
    this.observers = new Array();
}

BUtil.Observer.prototype.attach = function(arg) {
    this.observers.push(arg);
}

BUtil.Observer.prototype.notify = function(arg) {
    for(var f in this.observers) {
	this.observers[f](arg);
    }
}


/* mimetex関連を内包するクラス */
BUtil.MimeTex = function(bredima) {
    this.bredima = bredima;
    this.uri = bredima.config['uri_mimetex'];
}

BUtil.MimeTex.sizeword = ['', 'large', 'normal'];

BUtil.MimeTex.prototype.getURI = function(str, size) {
    var s = '';
    if(typeof(size) == 'string') {
	s = size;
    }
    else if(typeof(size) == 'number') {
	s = BUtil.MimeTex.sizeword[size];
    }
    if(s != '') {
	s = BUtil.Const.backslash + s + ' ';
    }
    return encodeURI(this.uri + '?' + s + str);
}
