
/**
 * @class Rowfactorオブジェクトの共通抽象クラス
 * @constructor
 * @extends Bredima.Exp
 * this.rowの設定とrowのparam.order位置への挿入
 */
Bredima.Exp.Rowfactor = function(param) {
    arguments.callee.superClass.apply(this, arguments);
    this.row = param.parent;
}

Bredima.util.inherit(Bredima.Exp.Rowfactor, Bredima.Exp);

Bredima.util.setProperty(Bredima.Exp.Rowfactor, {
    margin: 1
});

/* ====================
 Exp.Rowfactorで定義
 */

/**
 * 要素のheadかtailにカーソルを置く
 * オーバーライドしなければカーソルが置けないrowfactor
 */
Bredima.Exp.Rowfactor.prototype.setCursorTo = function(loc) {
    return false;
}

/**
 * 選択されるべきinput要素を返す
 * オーバーライドしなければ選択できない
 */
Bredima.Exp.Rowfactor.prototype.getIncomingInput = function() {
    return false;
}

/**
 * rowの中の自分の位置を返す
 */
Bredima.Exp.Rowfactor.prototype.getOrder = function() {
    return this.row.orderOf(this);
}

/* ====================
 Expの実装
*/
Bredima.Exp.Rowfactor.prototype.repositionToRoot = function() {
    this._reposition();
    this.row.repositionToRoot();
}

