
/**
 * @class フレーム管理
 * @constructor
 * @extends Bredima.Panel
 */
Bredima.Frame = function(bredima, dom) {
    this.bredima = bredima;
    this.obj = dom;
    this.obj.className = 'BrEdiMa_Frame';

    // loading中の目隠し
    this.addDom('div', 'curtain');
    this.curtain.className = 'curtain';
    var note = document.createElement('p');
    note.appendChild(document.createTextNode('loading'));
    this.curtain.appendChild(note);

    this.eventObserver = new Bredima.Observer();
    var self = this;
    this.obj.onclick = function() {
	self.eventObserver.notify('FrameClick');
    }

    this.add(new Bredima.Panel(), 'buttons');
    this.buttons.add(new Bredima.Frame.Operation(bredima), 'mo');
    this.buttons.add(new Bredima.Frame.Container(bredima), 'container');

    this.add(new Bredima.Frame.About(bredima), 'about');
    var logo = new Bredima.Parts.Image('logo');
    logo.addClassName('bredima_logo');
    logo.getDom().onclick = function() { bredima.frame.about.show(); }
    this.add(logo);

    this.add(new Bredima.Frame.Source(bredima), 'source');
    this.add(new Bredima.Frame.Preview(bredima), 'preview');
}

Bredima.util.inherit(Bredima.Frame, Bredima.Panel);

Bredima.Frame.prototype.finalize = function() {
    this.buttons.add(new Bredima.Frame.Identifier(this.bredima), 'mi');
 
    this.add(this.bredima.exp.root);

    // 数式更新のタイミングでプレビューのアップデートをnotify
    this.bredima.exp.observer.attach(this.preview);
}

Bredima.Frame.prototype.appear = function() {
    var self = this;
    Bredima.util.animation({
			       start: 1, end: 0, step: 4,
			       func: function(num) {
				   Bredima.util.setOpacity(self.curtain, num);
			       },
			       finalize: function(){self.curtain.style.display = 'none';}
			   });
}
    
Bredima.style.add(
    [' ', 'position: relative; border: 1px solid #dcc; background-color: white; color: black; font-size: 14px; line-height: 1; padding: 2px;'],
    ['.curtain', 'position: absolute; width: 100%; height: 100%; left: 0; top: 0; background-color: #f2eeee; z-index: 10; text-align: center; vertical-align: bottom;'],
    ['.curtain p', 'position: absolute; bottom: 30%; left: 60%;'],
    ['.bredima_logo', 'position: absolute; top: 3px; right: 3px;']
);
