
/**
 * @class コンテナオブジェクト挿入ボタン管理オブジェクト
 * @constructor
 * @extends Bredima.Panel
 */
Bredima.Frame.Toolbar = function(bredima) {
    this.__super__(bredima);
    this.setClassName('toolbar');

    // 操作ボタン
    this.add(new Bredima.Parts.Button(
		 new Bredima.Parts.Image('btn_undo.png'),
		 function() {bredima.history.undo();}),
	     'undo');
    this.add(new Bredima.Parts.Button(
		 new Bredima.Parts.Image('btn_redo.png'),
		 function() {bredima.history.redo();}),
	     'redo');
    this.undo.setDisabled(true);
    this.redo.setDisabled(true);
    this.add(new Bredima.Parts.Button(
		 new Bredima.Parts.Image('btn_source.png'),
		 function() {bredima.frame.source.show(); }
	     ));
    
    this.addDom(document.createTextNode(' '));

    // 使用頻度が高そうなコンテナオブジェクト
    for(var i = 0; i < this.order.length; i++) {
	var curr = Bredima.Frame.Toolbar.expandContainerNotation(this.order[i], bredima);
	this.add(new Bredima.Parts.Button(curr.img, curr.func2));
    }

    // ポップアップメニュー
    this.add(new Bredima.Frame.Toolbar.Sub(bredima));
    this.add(new Bredima.Frame.Toolbar.Symbol(bredima, 'operator'));
    this.add(new Bredima.Frame.Toolbar.Symbol(bredima, 'identifier'));

    bredima.history.observer.attach(this);
}

Bredima.util.inherit(Bredima.Frame.Toolbar, Bredima.Panel);

/**
 * コンテナオブジェクト省略記法からボタン画像と挿入関数を作って返すクラス関数
 */
Bredima.Frame.Toolbar.expandContainerNotation = function(arg, bredima) {
    var classfunc; var img; var func;
    if(typeof arg == 'string') {
	classfunc = Bredima.Exp.getClassById(arg)
	img = arg;
	func = function(rd){return new classfunc(rd); };
    }
    else {
	classfunc = Bredima.Exp.getClassById(arg.id);
	img = (arg.img) ? arg.img : arg.id;
	func = function(rd){return new classfunc(rd, arg.arg)};
    }
    return {
	img: new Bredima.Parts.Image('btn_' + img + '.png'),
	func: func,
	func2: (bredima) ? function() {bredima.exp.insElement(func)} : null
    }
}

// やっぱり集中管理できた方が楽そうなのでここでボタンの列びを指定
Bredima.Frame.Toolbar.prototype.order = ['frac', {id: 'fenced', arg: '0'}, 'sqrt', 'sup', 'sub'];

/**
 * 履歴に変化があった場合の処理
 * @private
 */
Bredima.Frame.Toolbar.prototype.onHistoryEnableChange = function(name) {
    var btn = ((name.indexOf('undo') >= 0) ? this.undo : 
	       ((name.indexOf('redo') >= 0) ? this.redo : ''));
    if(btn) btn.setDisabled((name.indexOf('disable') >= 0) ? true : false);
}


Bredima.style.add(
    ['.toolbar button', 'font-size: 12px; padding: 1px 2px;']
);

/* ================================
*/
/**
 * @class 使用頻度が低そうなコンテナオブジェクトをまとめたポップアップメニュー
 * @constructor
 * @extends Bredima.Parts.MenuButton
 */
Bredima.Frame.Toolbar.Sub = function(bredima) {
    this.bredima = bredima;
    var menu = new Bredima.Panel.MatrixMenu();
    for(var row = 0; row < this.order.length; row++) {
	for(var col = 0; col < this.order[row].length; col++) {
	    var curr = Bredima.Frame.Toolbar.expandContainerNotation(this.order[row][col]);
	    menu.addMenuItem(curr.img, curr.func);
	}
	menu.newLine();
    }
    bredima.menu.addMenu(menu, 'container');
    this.__super__(bredima, 'container');
}

Bredima.util.inherit(Bredima.Frame.Toolbar.Sub, Bredima.Parts.MenuButton);

Bredima.Frame.Toolbar.Sub.prototype.order = [
    ['root', 'over', 'vector'],
    ['sum', 'integral', 'intinterval'],
    [{id: 'permutation', arg: '0'}, {id: 'permutation', arg: 1, img: 'combination'}, {id: 'permutation', arg: 2, img: 'homogeneous'}]
];

/**
 * メニューがクリックされた時の処理
 */
Bredima.Frame.Toolbar.Sub.prototype.menuClickPerformed = function(arg) {
    this.bredima.exp.insElement(arg.attr);
}

/* ================================
*/
/**
 * @class シンボル挿入ボタン
 * @constructor
 * @extends Bredima.Parts.MenuButton
 * @param {String} id シンボルの種類 operator/identifier
 */
Bredima.Frame.Toolbar.Symbol = function(bredima, id) {
    this.bredima = bredima;
    var menu = new Bredima.Panel.MatrixMenu();
    for(var row = 0; row < this.order[id].length; row++) {
	for(var col = 0; col < this.order[id][row].length; col++) {
	    var curr = this.order[id][row][col];
	    menu.addMenuItem(
		new Bredima.Parts.Symbol(bredima, curr, 1, 'fixsize'),
		(function(name) {
		     return function(rd) {return new Bredima.Token.Symbol(rd, name);};
		 })(curr));
	}
	menu.newLine();
    }
    bredima.menu.addMenu(menu, id);
    this.__super__(bredima, id);
}

Bredima.util.inherit(Bredima.Frame.Toolbar.Symbol, Bredima.Parts.MenuButton);

Bredima.Frame.Toolbar.Symbol.prototype.order = {
    operator: [
	['sdot', 'times', 'divide', 'PlusMinus', 'MinusPlus', 'NotEqual', 'lE', 'gE'],
	['sub', 'sup', 'sube', 'supe', 'isin', 'ni', 'cup', 'cap'],
	['larr', 'rarr', 'lArr', 'rArr', 'hArr'],
	['compfn', 'ctdot', 'equiv', 'perp']
    ],
    identifier: [
	['alpha', 'beta', 'delta', 'epsiv'],
	['gamma', 'omega', 'phi', 'phiv'],
	['theta', 'Delta', 'pi'],
	['infin', 'bigtriangleup']
    ]
};

/**
 * メニューがクリックされた時の処理
 */
Bredima.Frame.Toolbar.Symbol.prototype.menuClickPerformed = function(arg) {
    this.bredima.exp.insElement(arg.attr);
}
