
/**
 * ポップアップメニュー
 * @constructor
 * @extends Bredima.Panel
 */
Bredima.Panel.Menu = function() {
    arguments.callee.superClass.apply(this, arguments);
    this.setClassName('menu');
    this.observer = new Bredima.Observer();
    this.serial = 0;
}

Bredima.util.inherit(Bredima.Panel.Menu, Bredima.Panel);

/**
 * メニュー項目を追加
 * @param {Object} elem 追加するParts
 */
Bredima.Panel.Menu.prototype.addMenuItem = function(elem) {
    var self = this;
    var p = document.createElement('p');
    p.className = 'menu_item';
    Bredima.util.addListener(p, 'click',
			     (function(num) {
				  return function(evt) {
				      Bredima.util.stopEvent(evt);
				      self.observer.notify('MenuClick', num); };
			      })(this.serial++));
    p.appendChild(elem.getDom());
    this.addDom(p);
}

Bredima.style.add(
    ['.menu', 'position: absolute; z-index: 1; border: 1px solid gray; background-color:silver; text-align: center;'],
    ['.menu .menu_item', 'margin: 1px 0; padding: 0; background-color: white; line-height: 0;']
);

/* ================================
*/
/**
 * 2次元配列ポップアップメニュー
 * @constructor
 * @extends Bredima.Panel
 */
Bredima.Panel.MatrixMenu = function() {
    arguments.callee.superClass.apply(this, arguments);
    this.setClassName('menu');
    this.observer = new Bredima.Observer();
    this.serial = 0;
    this.addDom(document.createElement('table'), 'table');
    this.tr = this.table.insertRow(0);
}

Bredima.util.inherit(Bredima.Panel.MatrixMenu, Bredima.Panel);

/**
 * メニューに項目を追加
 * @param {Object} elem 追加するパーツ
 * @param {Any} ret 項目クリック時にメニュー使用者に渡される項目
 */
Bredima.Panel.MatrixMenu.prototype.addMenuItem = function(elem, ret) {
    var td = this.tr.insertCell(-1);
    var self = this;
    td.className = 'menu_item';
    Bredima.util.addListener(td, 'click',
			     (function(ret) {
				  return function(evt) {
				      Bredima.util.stopEvent(evt);
				      self.observer.notify('MenuClick', ret);
				  }
			      })({serial: this.serial++, attr: ret}));
    td.appendChild(elem.getDom());
}

/**
 * メニューに改行を追加
 */
Bredima.Panel.MatrixMenu.prototype.newLine = function() {
    this.tr = this.table.insertRow(-1);
}

