/**
 * @class メインクラス
 */
Bredima = function(dom, type) {
    this.serial = Bredima.serial++;
    this.dom = dom;

    // 初期設定から設定をコピー
    this.config = {};
    for(var key in Bredima.config.def) {
	this.config[key] = Bredima.config.def[key];
    }

    if(type == 'float') {
	this.ignition = dom;
	this.dom = document.createElement('div');
	this.dom.style.width = '580px';
	this.dom.style.position = 'absolute';
	this.dom.style.display = 'none';
	var body = document.getElementsByTagName('body')[0];
	body.appendChild(this.dom);
	var self = this;
	Bredima.util.addListener(this.ignition, 'click',
				 function() {
				     var offset = Bredima.util.getOffset(self.ignition, body);
				     self.dom.style.left = Math.min(offset.left, body.clientWidth - 590) + 'px';
				     self.dom.style.top = (offset.top + 24) + 'px';
				     if(self.isIgnited) {
					 self.frame.toggleVisibility();
				     }
				     else {
					 self.isIgnited = true;
					 self.dom.style.display = 'block';
					 self.write();
				     }
				 });
    }
}

Bredima.version = '0.7.4.20080120';

/* ==============================
 外向きクラス関数
*/

/**
 * 全フレーム共通の設定を行う
 */
Bredima.setConfig = function(key, val) {
    Bredima.config.set(key, val);
}

/**
 * 指定したtextarea/inputに文字列を挿入するユーティリティ関数
 * @param {Object} dom DOMオブジェクト
 * @param {String} str 挿入する文字列
*/
Bredima.insertTo = function(dom, str) {
    dom.focus();
    if(dom.selectionStart != null) {
	var start = dom.selectionStart;
	var end = dom.selectionEnd;
	dom.value = dom.value.substring(0, start) +
	    str + dom.value.substring(end);
	dom.setSelectionRange(start, end + str.length);
    }
    else {
	var range = document.selection.createRange();
	range.text = str;
	range.select();
    }
}

/* ---------------------------------
内向き
*/
Bredima.serial = 0;

/* ==============================
 外向きインスタンス関数
*/
/**
 * インスタンスの設定を変更
 */
Bredima.prototype.setConfig = function(key, val) {
    for(var v in this.config) {
	if(v == key) {
	    this.config[key] = val;
	}
    }
}

/**
 * MathML出力
 */
Bredima.prototype.toMML = function(expand) { return this.exp.root.toMML(expand); }

/**
 * LaTeX出力
 */
Bredima.prototype.toLatex = function() { return this.exp.root.toLatex(); }

/**
 * JSON出力
 */
Bredima.prototype.toJSON = function() {
    var rd = this.exp.root.toRundown();
    if(rd.toJSON)
	return rd.toJSON();
    else
	return JSON.stringify(rd);
}

/**
 * 指定された領域にフレーム作成
 */
Bredima.prototype.write = function(dom) {
    if(dom) this.dom = dom;
    this.init = new Bredima.Init();
    this.locale = new Bredima.Locale(this);
    this.history = new Bredima.History();
    this.frame = new Bredima.Frame(this, this.dom);
    this.exp = new Bredima.ExpCtrl(this);
    this.menu = new Bredima.Menu(this);
    this.init.observer.attach(this);
    this.init.exec();
}

Bredima.prototype.setExpression = function(json) {
    this.exp.init(JSON.parse(json));
}

/**
 * 「挿入」ボタンを押した際のイベントハンドラ
 * 利用する場合は別の関数を上書き代入
 */
Bredima.prototype.onsubmit = function() {}

Bredima.prototype.onchange = function() {}
/* ---------------------------------
内向き
*/
/**
 * （アクセサ）Bredimaの設定を返す
 */
Bredima.prototype.getConfig = function(key) { return this.config[key];}

/**
 * 初期化終了時に呼ばれる
 */
Bredima.prototype.onInitialized = function() {
    var rundown = (this.config.json) ? JSON.parse(this.config.json) : null;
    this.frame.finalize();
    this.exp.init(rundown, 'first');
    //this.frame.appear();
}
