use POSIX;

@Height = (22, 18);
while (<STDIN>) {
    chomp;
    @c = split(/\t/);
    if($c[0] =~ /^\s*$/) {
	print "\n";
    }
    else {
	for($i = 0; $i <= 1; $i++) {
	    $H = $Height[$i];
	    $width = $c[5 + $i * 2];
	    $height = $c[6 + $i * 2];
	    $mag = 1;
	    if(($width > $H) || ($height > $H)) {
		$mag = $H / (($width < $height) ? $height : $width);
	    }
	    $mw = floor($H - $width * $mag);
	    $mh = floor($H - $height * $mag);
	    $margin[0] = ceil($mh / 2);
	    $margin[2] = floor($mh / 2);
	    $margin[1] = floor($mw / 2);
	    $margin[3] = ceil($mw / 2);
	    $size[$i] = "{width: $width, height: $height, margin: {top: $margin[0], right: $margin[1], bottom: $margin[2], left: $margin[3]}}";
	}
	print "    $c[2]: {code: '\\u$c[0]', tex: '$c[3]', img: ['',\n        $size[0],\n        $size[1]]},\n";
    }
}
