
/**
 * @classタブ部品っぽいもの
 * @constructor
 * @param {Array} labels 表示するラベルの一覧 中身はStringのみ
 */
Bredima.Panel.Tab = function(labels) {
    this.__super__();
    this.setClassName('tab');
    this.observer = new Bredima.Observer();
    this.labels = new Array;
    this.selected = 0;
    var label;
    var self = this;
    for(var i = 0; i < labels.length; i++) {
	label = document.createElement('span');
	label.appendChild(document.createTextNode(labels[i]));
	Bredima.util.addListener(label, 'click', 
				 (function(num) {return function(evt) {
						     self._click(num, evt);
						 };})(i));
	this.obj.appendChild(label);
	this.labels.push(label);
    }
}

Bredima.util.inherit(Bredima.Panel.Tab, Bredima.Panel);

Bredima.Panel.Tab.prototype.getSelectedNum = function() {
    return this.selected;
}

/**
 * 指定したタブをハイライト
 * @param {Number} num タブの番号
 */
Bredima.Panel.Tab.prototype.hilite = function(num) {
    for(var i = 0; i < this.labels.length; i++) {
	this.labels[i].className = (i == num) ? 'selected' : '';
    }
}

/**
 * タブがクリックされたときのイベントハンドラ
 * @private
 */
Bredima.Panel.Tab.prototype._click = function(num, evt) {
    this.hilite(num);
    Bredima.util.stopEvent(evt);
    this.selected = num;
    this.observer.notify('TabClick', num);
}


Bredima.style.add(
    ['.tab', 'border-bottom: 1px solid #855;'],
    ['.tab span', 'border: 1px solid #855; border-bottom: 0; background-color: linen; padding: 0 6px; margin: 0px 5px; cursor: default;'],
    ['.tab span.selected', 'background-color: #855; color: white;']
);
