
/**
 @fileoverview
 1つのファイルにするまでもないクラスをまとめたファイル
*/

/**
 * @class 選択範囲の記録
 * @constructor
 */
Bredima.Range = function(start, end) {
    this.start = start;
    this.end = end;
}

/**
 * 選択範囲が同一のものか判定
 * @param {Object} r2 比較する選択範囲オブジェクト
 */
Bredima.Range.prototype.equals = function(r2) {
    return ((this.start == r2.start) && (this.end == r2.end));
}

/* ============================
*/
/**
 * @class Observerパターン
 * @constructor
 */
Bredima.Observer = function() {
    this.observers = new Array;
}

/**
 * 通知を行うオブジェクト/関数を追加
 * @param {Object} arg 通知先のオブジェクト、あるいは実行する関数
 */
Bredima.Observer.prototype.attach = function(arg) {
    this.observers.push(arg);
}

/**
 * 通知先を削除
 * @param {Object} arg 通知先リストから削除するオブジェクト/関数
 */
Bredima.Observer.prototype.detach = function(arg) {
    for(var i = 0; i < this.observers.length; i++) {
	if(arg == this.observers[i]) {
	    this.observers.splice(i, 1);
	    return true;
	}
    }
    return false;
}

/**
 * 登録した関数へ通知
 * @param {String} arg 通知文字列
 */
Bredima.Observer.prototype.notify = function(evt, prop) {
    for(var i = 0; i < this.observers.length; i++) {
	if(this.observers[i]['on' + evt]) this.observers[i]['on' + evt](prop);
    }
}

/**
 * @class 初期化管理クラス
 * @constructor
 */
Bredima.Init = function() {
    this.observer = new Bredima.Observer(); // 初期化終了を各インスタンスに伝えるObserver
}

Bredima.Init.isDone = false;
Bredima.Init.classes = new Array;
Bredima.Init.finished = 0;
Bredima.Init.initializers = new Array;

/**
 * 初期化が必要なクラスを登録
 */
Bredima.Init.attachInit = function(c) { // 初期化開始を各クラスに伝えるObserver
    Bredima.Init.classes.push(c);
}

/**
 * 呼ばれたクラスの初期化完了を連絡
 */
Bredima.Init.ackFinish = function() {
    if(++Bredima.Init.finished == Bredima.Init.classes.length) {
	// 初期化終了
	Bredima.Init.isDone = true;
	for(var i = 0; i < Bredima.Init.initializers.length; i++)
	    Bredima.Init.initializers[i].observer.notify('Initialized');
    }
}

/**
 * 初期化実行
 */
Bredima.Init.prototype.exec = function() {
    if(Bredima.Init.isDone)
	this.observer.notify('Initialized');
    else {
	Bredima.Init.initializers.push(this);
	if(Bredima.Init.initializers.length == 1) {
	    for(var i = 0; i < Bredima.Init.classes.length; i++) {
		Bredima.Init.classes[i].initializeOnLoad();
	    }
	}
    }
}