/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms;

import edu.uci.ics.jung.utils.NumericalPrecision;

public abstract class IterativeProcess {
    private int iterations;
    private int maximumIterations = 50;
    private double desiredPrecision = NumericalPrecision.defaultNumericalPrecision();
    private double precision;

    public void evaluate() {
        this.iterations = 0;
        this.initializeIterations();
        while (this.iterations++ < this.maximumIterations) {
            this.precision = this.evaluateIteration();
            if (!this.hasConverged()) continue;
        }
        this.finalizeIterations();
    }

    protected abstract double evaluateIteration();

    protected void finalizeIterations() {
    }

    public double getDesiredPrecision() {
        return this.desiredPrecision;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getMaximumIterations() {
        return this.maximumIterations;
    }

    public double getPrecision() {
        return this.precision;
    }

    public boolean hasConverged() {
        return this.precision < this.desiredPrecision;
    }

    protected void initializeIterations() {
    }

    protected void reinitialize() {
    }

    public double relativePrecision(double epsilon, double x) {
        return x > NumericalPrecision.defaultNumericalPrecision() ? epsilon / x : epsilon;
    }

    public void setDesiredPrecision(double prec) throws IllegalArgumentException {
        if (prec <= 0.0) {
            throw new IllegalArgumentException("Non-positive precision: " + prec);
        }
        this.desiredPrecision = prec;
    }

    public void setMaximumIterations(int maxIter) throws IllegalArgumentException {
        if (maxIter < 1) {
            throw new IllegalArgumentException("Non-positive maximum iteration: " + maxIter);
        }
        this.maximumIterations = maxIter;
    }
}

