/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.connectivity;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.NumericDecorator;
import edu.uci.ics.jung.utils.UserData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BFSDistanceLabeler {
    public static final String DEFAULT_DISTANCE_KEY = "algorithms.connectivity.BFSDiststanceLabeler.DISTANCE_KEY";
    private NumericDecorator mDistanceDecorator;
    private List mCurrentList;
    private Set mUnvisitedVertices;
    private List mVerticesInOrderVisited;
    private Map mPredecessorMap;

    public BFSDistanceLabeler(String distanceKey) {
        this.mDistanceDecorator = new NumericDecorator(distanceKey, UserData.SHARED);
        this.mPredecessorMap = new HashMap();
    }

    public BFSDistanceLabeler() {
        this.mDistanceDecorator = new NumericDecorator(DEFAULT_DISTANCE_KEY, UserData.SHARED);
        this.mPredecessorMap = new HashMap();
    }

    public List getVerticesInOrderVisited() {
        return this.mVerticesInOrderVisited;
    }

    public Set getUnivistedVertices() {
        return this.mUnvisitedVertices;
    }

    public int getDistance(Graph g, Vertex v) {
        if (!g.getVertices().contains(v)) {
            throw new IllegalArgumentException("Vertex is not contained in the graph.");
        }
        return this.mDistanceDecorator.getValue(v).intValue();
    }

    public Set getPredecessors(Vertex v) {
        return (Set)this.mPredecessorMap.get(v);
    }

    protected void initialize(Graph g, Set rootSet) {
        this.mVerticesInOrderVisited = new ArrayList();
        this.mUnvisitedVertices = new HashSet();
        Iterator vIt = g.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            this.mUnvisitedVertices.add(currentVertex);
            this.mPredecessorMap.put(currentVertex, new HashSet());
        }
        this.mCurrentList = new ArrayList();
        Iterator rootIt = rootSet.iterator();
        while (rootIt.hasNext()) {
            Vertex v = (Vertex)rootIt.next();
            this.mDistanceDecorator.setValue(new Integer(0), v);
            this.mCurrentList.add(v);
            this.mUnvisitedVertices.remove(v);
            this.mVerticesInOrderVisited.add(v);
        }
    }

    private void addPredecessor(Vertex predecessor, Vertex sucessor) {
        HashSet predecessors = (HashSet)this.mPredecessorMap.get(sucessor);
        predecessors.add(predecessor);
    }

    public void removeDecorations(Graph g) {
        Iterator vIt = g.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex v = (Vertex)vIt.next();
            this.mDistanceDecorator.removeValue(v);
        }
    }

    public void labelDistances(Graph graph, Set rootSet) {
        this.initialize(graph, rootSet);
        int distance = 1;
        while (true) {
            ArrayList newList = new ArrayList();
            Iterator vIt = this.mCurrentList.iterator();
            while (vIt.hasNext()) {
                Vertex currentVertex = (Vertex)vIt.next();
                Iterator uIt = currentVertex.getSuccessors().iterator();
                while (uIt.hasNext()) {
                    this.visitNewVertex(currentVertex, (Vertex)uIt.next(), distance, newList);
                }
            }
            if (newList.size() == 0) break;
            this.mCurrentList = newList;
            ++distance;
        }
        Iterator vIt = this.mUnvisitedVertices.iterator();
        while (vIt.hasNext()) {
            Vertex v = (Vertex)vIt.next();
            this.mDistanceDecorator.setValue(new Integer(-1), v);
        }
    }

    public void labelDistances(Graph graph, Vertex root) {
        HashSet<Vertex> rootSet = new HashSet<Vertex>();
        rootSet.add(root);
        this.labelDistances(graph, rootSet);
    }

    private void visitNewVertex(Vertex predecessor, Vertex neighbor, int distance, List newList) {
        int successorDistance;
        int predecessorDistance;
        if (this.mUnvisitedVertices.contains(neighbor)) {
            this.mDistanceDecorator.setValue(new Integer(distance), neighbor);
            newList.add(neighbor);
            this.mVerticesInOrderVisited.add(neighbor);
            this.mUnvisitedVertices.remove(neighbor);
        }
        if ((predecessorDistance = this.mDistanceDecorator.getValue(predecessor).intValue()) < (successorDistance = this.mDistanceDecorator.getValue(neighbor).intValue())) {
            this.addPredecessor(predecessor, neighbor);
        }
    }
}

