/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import java.util.Iterator;

public class BaryCenter
extends AbstractRanker {
    public static final String KEY = "edu.uci.ics.jung.algorithms.importance.BaryCenter.RankScore";

    public BaryCenter(Graph g) {
        this.initialize(g, true, false);
    }

    protected double evaluateIteration() {
        DijkstraDistance p = new DijkstraDistance(this.getGraph());
        Iterator i = this.getVertices().iterator();
        while (i.hasNext()) {
            Vertex u = (Vertex)i.next();
            double baryCenter = 0.0;
            Iterator j = p.getDistanceMap(u).values().iterator();
            while (j.hasNext()) {
                baryCenter += ((Number)j.next()).doubleValue();
            }
            this.setRankScore(u, baryCenter);
        }
        return 0.0;
    }

    public String getRankScoreKey() {
        return KEY;
    }
}

