/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.decorators;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.utils.UserData;

public class GlobalStringLabeller
extends StringLabeller {
    protected static GlobalStringLabeller instance;

    protected GlobalStringLabeller() {
        super(null);
    }

    public static StringLabeller setLabellerTo(Graph g, Object key) {
        StringLabeller sl = GlobalStringLabeller.getInstance();
        if (key != null) {
            g.addUserDatum(key, sl, UserData.REMOVE);
        }
        return sl;
    }

    public static synchronized StringLabeller getInstance() {
        if (instance == null) {
            instance = new GlobalStringLabeller();
        }
        return instance;
    }

    public static StringLabeller getLabeller(Graph g) {
        return GlobalStringLabeller.setLabellerTo(g);
    }

    public static StringLabeller setLabellerTo(Graph g) {
        return GlobalStringLabeller.setLabellerTo(g, StringLabeller.DEFAULT_STRING_LABELER_KEY);
    }

    public static boolean hasStringLabeller(Graph g) {
        return GlobalStringLabeller.hasStringLabeller(g, DEFAULT_STRING_LABELER_KEY);
    }

    public static boolean hasStringLabeller(Graph g, Object key) {
        GlobalStringLabeller id = (GlobalStringLabeller)g.getUserDatum(key);
        return id != null;
    }

    public String getLabel(ArchetypeVertex v) {
        if (this.vertexToLabel.containsKey(v)) {
            return (String)this.vertexToLabel.get(v);
        }
        throw new FatalException("Vertex not registered in GlobalStringLabeller!");
    }

    public void setLabel(Vertex v, String l) throws StringLabeller.UniqueLabelException {
        if (this.labelToVertex.containsKey(l)) {
            throw new StringLabeller.UniqueLabelException(l + " is already on vertex " + this.labelToVertex.get(l));
        }
        if (this.vertexToLabel.containsKey(v)) {
            Object junk = this.vertexToLabel.get(v);
            this.labelToVertex.remove(junk);
        }
        this.vertexToLabel.put(v, l);
        this.labelToVertex.put(l, v);
    }
}

