/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.impl.AbstractArchetypeGraph;
import edu.uci.ics.jung.graph.impl.AbstractElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractArchetypeVertex
extends AbstractElement
implements ArchetypeVertex {
    public AbstractArchetypeVertex() {
        this.initialize();
    }

    public Set getIncidentElements() {
        return this.getIncidentEdges();
    }

    public Set getNeighbors() {
        return Collections.unmodifiableSet(new HashSet(this.getNeighbors_internal()));
    }

    public int numNeighbors() {
        return this.getNeighbors_internal().size();
    }

    public Set getIncidentEdges() {
        return Collections.unmodifiableSet(new HashSet(this.getEdges_internal()));
    }

    public int degree() {
        return this.getEdges_internal().size();
    }

    public boolean isNeighborOf(ArchetypeVertex v) {
        return this.getNeighbors_internal().contains(v);
    }

    public boolean isIncident(ArchetypeEdge e) {
        return this.getEdges_internal().contains(e);
    }

    public ArchetypeVertex copy(ArchetypeGraph g) {
        if (g == this.getGraph()) {
            throw new IllegalArgumentException("Source and destination graphs must be different");
        }
        try {
            AbstractArchetypeVertex v = (AbstractArchetypeVertex)this.clone();
            v.initialize();
            v.importUserData(this);
            return v;
        }
        catch (CloneNotSupportedException cne) {
            throw new FatalException("Failure in cloning " + this, cne);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArchetypeVertex)) {
            return false;
        }
        ArchetypeVertex v = (ArchetypeVertex)o;
        return this == v.getEqualVertex(this.getGraph());
    }

    public ArchetypeVertex getEqualVertex(ArchetypeGraph ag) {
        if (ag instanceof AbstractArchetypeGraph) {
            AbstractArchetypeGraph aag = (AbstractArchetypeGraph)ag;
            return aag.getVertexByID(this.getID());
        }
        return null;
    }

    public ArchetypeVertex getEquivalentVertex(ArchetypeGraph ag) {
        return this.getEqualVertex(ag);
    }

    public ArchetypeEdge findEdge(ArchetypeVertex v) {
        Iterator iter = this.getEdges_internal().iterator();
        while (iter.hasNext()) {
            ArchetypeEdge ae = (ArchetypeEdge)iter.next();
            if (!ae.isIncident(v)) continue;
            return ae;
        }
        return null;
    }

    public Set findEdgeSet(ArchetypeVertex v) {
        HashSet<ArchetypeEdge> edges = new HashSet<ArchetypeEdge>();
        Iterator iter = this.getEdges_internal().iterator();
        while (iter.hasNext()) {
            ArchetypeEdge ae = (ArchetypeEdge)iter.next();
            if (!ae.isIncident(v)) continue;
            edges.add(ae);
        }
        return Collections.unmodifiableSet(edges);
    }

    protected abstract Collection getNeighbors_internal();

    protected abstract Collection getEdges_internal();
}

