/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.predicates.TreePredicate;
import edu.uci.ics.jung.utils.UserData;

public class SparseTree
extends SparseGraph
implements DirectedGraph {
    protected Vertex mRoot;
    public static final Object SPARSE_ROOT_KEY = "edu.uci.ics.jung.graph.impl.SparseTree.RootKey";
    public static final Object IN_TREE_KEY = "edu.uci.ics.jung.graph.impl.SparseTree.InTreeKey";

    public SparseTree(Vertex root) {
        this.edge_requirements.add(TreePredicate.getInstance());
        this.edge_requirements.add(Graph.DIRECTED_EDGE);
        this.edge_requirements.add(Graph.NOT_PARALLEL_EDGE);
        this.mRoot = root;
        this.addVertex(root);
        this.mRoot.setUserDatum(SPARSE_ROOT_KEY, SPARSE_ROOT_KEY, UserData.SHARED);
        this.mRoot.setUserDatum(IN_TREE_KEY, IN_TREE_KEY, UserData.SHARED);
    }

    public Vertex getRoot() {
        return this.mRoot;
    }

    public Edge addEdge(Edge e) {
        Edge rv = super.addEdge(e);
        Vertex dest = (Vertex)rv.getEndpoints().getSecond();
        dest.setUserDatum(IN_TREE_KEY, IN_TREE_KEY, UserData.SHARED);
        return rv;
    }
}

