/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import edu.uci.ics.jung.utils.UserDataFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.IteratorUtils;

public class DefaultUserData
extends UserData
implements UserDataFactory {
    private Map userDataStorage;

    private Map getStorage() {
        if (this.userDataStorage == null) {
            this.userDataStorage = new HashMap();
        }
        return this.userDataStorage;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultUserData ud = (DefaultUserData)super.clone();
        ud.userDataStorage = null;
        return ud;
    }

    public void addUserDatum(Object key, Object value, UserDataContainer.CopyAction shared) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        if (this.getStorage().containsKey(key)) {
            throw new IllegalArgumentException("Key <" + key + "> had already been added to an object with keys " + this.getKeys());
        }
        this.getStorage().put(key, new Pair(value, shared));
    }

    private Set getKeys() {
        return this.getStorage().keySet();
    }

    public void importUserData(UserDataContainer udc) {
        Iterator keyIt = udc.getUserDatumKeyIterator();
        while (keyIt.hasNext()) {
            Object key = keyIt.next();
            Object value = udc.getUserDatum(key);
            UserDataContainer.CopyAction action = udc.getUserDatumCopyAction(key);
            Object newValue = action.onCopy(value, udc, this);
            try {
                if (newValue == null) continue;
                this.addUserDatum(key, newValue, action);
            }
            catch (IllegalArgumentException iae) {
                List userDataKeys = IteratorUtils.toList((Iterator)udc.getUserDatumKeyIterator());
                throw new FatalException("Copying <" + key + "> of " + userDataKeys + " into a container that started with some keys ", iae);
            }
        }
    }

    public void setUserDatum(Object key, Object value, UserDataContainer.CopyAction shared) {
        this.getStorage().put(key, new Pair(value, shared));
    }

    public Object getUserDatum(Object key) {
        Pair p = (Pair)this.getStorage().get(key);
        if (p == null) {
            return null;
        }
        return p.getFirst();
    }

    public Object removeUserDatum(Object key) {
        Object o = this.getUserDatum(key);
        this.getStorage().remove(key);
        return o;
    }

    public Iterator getUserDatumKeyIterator() {
        return this.getStorage().keySet().iterator();
    }

    public boolean containsUserDatumKey(Object key) {
        return this.getStorage().containsKey(key);
    }

    public UserDataContainer.CopyAction getUserDatumCopyAction(Object key) {
        Pair p = (Pair)this.getStorage().get(key);
        return (UserDataContainer.CopyAction)p.getSecond();
    }

    public UserDataContainer getInstance() {
        return new DefaultUserData();
    }
}

