/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.iterablelayouts;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.util.HashSet;
import java.util.Iterator;
import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.iter.GraphLayoutPanelUtils;
import samples.preview_new_graphdraw.iter.IterableLayout;

public abstract class InterpolatingIterableLayout
extends IterableLayout {
    protected EmittedLayout start;
    protected EmittedLayout end;
    protected final int numFrames;
    int thisFrame = 0;

    public InterpolatingIterableLayout(EmittedLayout end, int numFrames) {
        this.end = end;
        this.numFrames = numFrames;
    }

    public boolean iterationsAreDone() {
        return this.thisFrame >= this.numFrames;
    }

    public boolean isFinite() {
        return true;
    }

    protected void calculate() {
        HashSet vertices = new HashSet(this.start.visVertexMap.keySet());
        vertices.addAll(this.end.visVertexMap.keySet());
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            VisVertex startV = this.start.getVisVertex(v);
            VisVertex endV = this.end.getVisVertex(v);
            this.currentLayout.visVertexMap.put(v, this.interpolateV(startV, endV, this.thisFrame, this.numFrames));
        }
        HashSet edges = new HashSet(this.start.visEdgeMap.keySet());
        edges.addAll(this.end.visEdgeMap.keySet());
        Iterator iter2 = edges.iterator();
        while (iter2.hasNext()) {
            Edge e = (Edge)iter2.next();
            VisEdge startE = this.start.getVisEdge(e);
            VisEdge endE = this.end.getVisEdge(e);
            VisVertex f = this.currentLayout.getVisVertex((Vertex)e.getEndpoints().getFirst());
            VisVertex s = this.currentLayout.getVisVertex((Vertex)e.getEndpoints().getSecond());
            this.currentLayout.visEdgeMap.put(e, this.interpolateE(startE, endE, f, s, this.thisFrame, this.numFrames));
        }
        ++this.thisFrame;
    }

    public void initializeLocationsFromLayout(EmittedLayout inputLayout) {
        super.initializeLocationsFromLayout(inputLayout);
        this.start = GraphLayoutPanelUtils.copy(this.currentLayout);
    }

    protected abstract VisEdge interpolateE(VisEdge var1, VisEdge var2, VisVertex var3, VisVertex var4, int var5, int var6);

    protected abstract VisVertex interpolateV(VisVertex var1, VisVertex var2, int var3, int var4);
}

