/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;

public class ArrayElementValueGen
extends ElementValueGen {
    private List evalues;

    public ArrayElementValueGen(ConstantPoolGen cp) {
        super(91, cp);
        this.evalues = new ArrayList();
    }

    public ArrayElementValueGen(int type, ElementValue[] datums, ConstantPoolGen cpool) {
        super(type, cpool);
        if (type != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor");
        }
        this.evalues = new ArrayList();
        int i = 0;
        while (i < datums.length) {
            this.evalues.add(datums[i]);
            ++i;
        }
    }

    public ElementValue getElementValue() {
        ElementValue[] immutableData = new ElementValue[this.evalues.size()];
        int i = 0;
        for (ElementValueGen element : this.evalues) {
            immutableData[i++] = element.getElementValue();
        }
        return new ArrayElementValue(this.type, immutableData, this.cpGen.getConstantPool());
    }

    public ArrayElementValueGen(ArrayElementValue value, ConstantPoolGen cpool, boolean copyPoolEntries) {
        super(91, cpool);
        this.evalues = new ArrayList();
        ElementValue[] in = value.getElementValuesArray();
        int i = 0;
        while (i < in.length) {
            this.evalues.add(ElementValueGen.copy(in[i], cpool, copyPoolEntries));
            ++i;
        }
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        dos.writeShort(this.evalues.size());
        for (ElementValueGen element : this.evalues) {
            element.dump(dos);
        }
    }

    public String stringifyValue() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        Iterator iter = this.evalues.iterator();
        while (iter.hasNext()) {
            ElementValueGen element = (ElementValueGen)iter.next();
            sb.append(element.stringifyValue());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public List getElementValues() {
        return this.evalues;
    }

    public int getElementValuesSize() {
        return this.evalues.size();
    }

    public void addElement(ElementValueGen gen) {
        this.evalues.add(gen);
    }
}

