/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeTabPaneDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class TabFolderDrawData
extends DrawData {
    public int tabsWidth;
    public int tabsHeight;
    public Rectangle tabsArea;
    public int selectedX;
    public int selectedWidth;
    public int spacing;

    public TabFolderDrawData() {
        this.state = new int[1];
        if (SWT.getPlatform().equals("gtk")) {
            this.spacing = -2;
        }
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        int[] metric = new int[1];
        OS.GetThemeMetric(10, metric);
        int tabHeight = metric[0];
        OS.GetThemeMetric(11, metric);
        int capsWidth = metric[0];
        CGRect rect = new CGRect();
        rect.x = bounds.x;
        rect.y = bounds.y;
        rect.width = bounds.width;
        rect.height = bounds.height;
        if ((this.style & 0x400) != 0) {
            rect.height -= (float)(tabHeight / 2);
        } else {
            rect.y += (float)((capsWidth + tabHeight) / 2);
            rect.height -= (float)((capsWidth + tabHeight) / 2);
        }
        HIThemeTabPaneDrawInfo info = this.getInfo();
        OS.HIThemeDrawTabPane(rect, info, gc.handle, 0);
        if (this.tabsArea != null) {
            this.tabsArea.x = bounds.x + capsWidth + (bounds.width - capsWidth * 2 - this.tabsWidth) / 2;
            this.tabsArea.y = bounds.y;
            this.tabsArea.width = bounds.width - capsWidth * 2;
            this.tabsArea.height = tabHeight;
            this.tabsArea.y = (this.style & 0x400) != 0 ? (this.tabsArea.y += bounds.height - tabHeight) : (this.tabsArea.y += capsWidth / 2);
        }
    }

    HIThemeTabPaneDrawInfo getInfo() {
        int state = this.state[0];
        HIThemeTabPaneDrawInfo info = new HIThemeTabPaneDrawInfo();
        info.version = 1;
        info.direction = 0;
        if ((this.style & 0x400) != 0) {
            info.direction = 1;
        }
        if ((this.style & 0x80) != 0) {
            info.direction = 0;
        }
        info.state = (state & 8) != 0 ? 2 : ((state & 0x10) != 0 ? ((state & 0x20) == 0 ? 1 : 7) : ((state & 0x20) == 0 ? 0 : 8));
        return info;
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        if (!bounds.contains(position)) {
            return -1;
        }
        return 0;
    }
}

