/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ast;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.JavaParserTreeConstants;
import net.sourceforge.pmd.ast.JavaParserVisitor;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.symboltable.Scope;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;
    private String image;
    private int beginLine = -1;
    private int endLine;
    private int beginColumn = -1;
    private int endColumn;
    private Scope scope;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassBody;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(JavaParser p, int i) {
        this(i);
        this.parser = p;
    }

    public void jjtOpen() {
        if (this.parser.token.next != null) {
            this.beginLine = this.parser.token.next.beginLine;
            this.beginColumn = this.parser.token.next.beginColumn;
        }
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        if (this.scope == null) {
            return ((SimpleNode)this.parent).getScope();
        }
        return this.scope;
    }

    public void jjtClose() {
        if (this.children == null || this.children.length == 0) {
            this.beginLine = this.parser.token.beginLine;
            this.beginColumn = this.parser.token.beginColumn;
        }
        this.endLine = this.parser.token.endLine;
        this.endColumn = this.parser.token.endColumn;
    }

    public int getBeginLine() {
        if (this.beginLine != -1) {
            return this.beginLine;
        }
        if (this.children != null && this.children.length > 0) {
            return ((SimpleNode)this.children[0]).getBeginLine();
        }
        throw new RuntimeException("Unable to determine begining line of Node.");
    }

    public void testingOnly__setBeginLine(int i) {
        this.beginLine = i;
    }

    public void testingOnly__setBeginColumn(int i) {
        this.beginColumn = i;
    }

    public int getBeginColumn() {
        if (this.beginColumn != -1) {
            return this.beginColumn;
        }
        if (this.children != null && this.children.length > 0) {
            return ((SimpleNode)this.children[0]).getBeginColumn();
        }
        throw new RuntimeException("Unable to determine begining line of Node.");
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public List findChildrenOfType(Class targetType) {
        ArrayList list = new ArrayList();
        this.findChildrenOfType(targetType, list);
        return list;
    }

    public void findChildrenOfType(Class targetType, List results) {
        this.findChildrenOfType(this, targetType, results, true);
    }

    public void findChildrenOfType(Class targetType, List results, boolean descendIntoNestedClasses) {
        this.findChildrenOfType(this, targetType, results, descendIntoNestedClasses);
    }

    private void findChildrenOfType(Node node, Class targetType, List results, boolean descendIntoNestedClasses) {
        if (node.getClass().equals(targetType)) {
            results.add(node);
        }
        if (node.getClass().equals(class$net$sourceforge$pmd$ast$ASTClassBody == null ? (class$net$sourceforge$pmd$ast$ASTClassBody = SimpleNode.class$("net.sourceforge.pmd.ast.ASTClassBody")) : class$net$sourceforge$pmd$ast$ASTClassBody) && !descendIntoNestedClasses) {
            return;
        }
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            Node child = node.jjtGetChild(i);
            if (child.jjtGetNumChildren() > 0) {
                this.findChildrenOfType(child, targetType, results, descendIntoNestedClasses);
            } else if (child.getClass().equals(targetType)) {
                results.add(child);
            }
            ++i;
        }
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(JavaParserVisitor visitor, Object data) {
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                this.children[i].jjtAccept(visitor, data);
                ++i;
            }
        }
        return data;
    }

    public String toString() {
        return JavaParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump(prefix + " ");
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

