/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.GridBagHelper;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.SimpleRenderer;

public class GUI
implements CPDListener {
    private JTextField rootDirectoryField = new JTextField(System.getProperty("user.home"));
    private JTextField minimumLengthField = new JTextField("75");
    private JTextField timeField = new JTextField(6);
    private JTextField comparisonsField = new JTextField(8);
    private JProgressBar tokenizingFilesBar = new JProgressBar();
    private JTextArea resultsTextArea = new JTextArea();
    private JCheckBox recurseCheckbox = new JCheckBox("", true);
    private JComboBox languageBox = new JComboBox();
    private JFrame frame = new JFrame("PMD Cut and Paste Detector");

    public GUI() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('f');
        JMenuItem saveItem = new JMenuItem("Save");
        saveItem.setMnemonic('s');
        saveItem.addActionListener(new SaveListener());
        fileMenu.add(saveItem);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setMnemonic('x');
        exitItem.addActionListener(new CancelListener());
        fileMenu.add(exitItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        this.frame.setJMenuBar(menuBar);
        JButton browseButton = new JButton("Browse");
        browseButton.setMnemonic('b');
        browseButton.addActionListener(new BrowseListener());
        JButton goButton = new JButton("Go");
        goButton.setMnemonic('g');
        goButton.addActionListener(new GoListener());
        JButton cxButton = new JButton("Cancel");
        cxButton.addActionListener(new CancelListener());
        JPanel settingsPanel = this.makeSettingsPanel(browseButton, goButton, cxButton);
        JPanel progressPanel = this.makeProgressPanel();
        JPanel resultsPanel = this.makeResultsPanel();
        this.frame.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)settingsPanel, "North");
        topPanel.add((Component)progressPanel, "Center");
        this.frame.getContentPane().add((Component)topPanel, "North");
        this.frame.getContentPane().add((Component)resultsPanel, "Center");
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.show();
    }

    private JPanel makeSettingsPanel(JButton browseButton, JButton goButton, JButton cxButton) {
        JPanel settingsPanel = new JPanel();
        GridBagHelper helper = new GridBagHelper(settingsPanel, new double[]{0.2, 0.7, 0.1, 0.1});
        helper.addLabel("Root source directory:");
        helper.add(this.rootDirectoryField);
        helper.add(browseButton, 2);
        helper.nextRow();
        helper.addLabel("Minimum tile size:");
        this.minimumLengthField.setColumns(4);
        helper.add(this.minimumLengthField);
        helper.addLabel("Language:");
        this.languageBox.addItem("Java");
        this.languageBox.addItem("C++");
        this.languageBox.addItem("PHP");
        helper.add(this.languageBox);
        helper.nextRow();
        helper.addLabel("Also scan subdirectories?");
        helper.add(this.recurseCheckbox);
        helper.add(goButton);
        helper.add(cxButton);
        helper.nextRow();
        settingsPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        return settingsPanel;
    }

    private JPanel makeProgressPanel() {
        JPanel progressPanel = new JPanel();
        double[] weights = new double[]{0.0, 0.8, 0.4, 0.2};
        GridBagHelper helper = new GridBagHelper(progressPanel, weights);
        helper.addLabel("Tokenizing files:");
        helper.add(this.tokenizingFilesBar, 3);
        helper.nextRow();
        helper.addLabel("Comparisons so far:");
        helper.add(this.comparisonsField);
        helper.addLabel("Time elapsed:");
        helper.add(this.timeField);
        helper.nextRow();
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        return progressPanel;
    }

    private JPanel makeResultsPanel() {
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BorderLayout());
        JScrollPane areaScrollPane = new JScrollPane(this.resultsTextArea);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setPreferredSize(new Dimension(600, 300));
        resultsPanel.add((Component)areaScrollPane, "Center");
        resultsPanel.setBorder(BorderFactory.createTitledBorder("Results"));
        return resultsPanel;
    }

    private void go() {
        block12: {
            try {
                Language language = null;
                LanguageFactory lf = new LanguageFactory();
                if (this.languageBox.getSelectedItem().equals("Java")) {
                    language = lf.createLanguage("java");
                } else if (this.languageBox.getSelectedItem().equals("C++")) {
                    language = lf.createLanguage("cpp");
                } else if (this.languageBox.getSelectedItem().equals("PHP")) {
                    language = lf.createLanguage("php");
                }
                CPD cpd = new CPD(Integer.parseInt(this.minimumLengthField.getText()), language);
                cpd.setCpdListener(this);
                this.tokenizingFilesBar.setMinimum(0);
                this.comparisonsField.setText("");
                if (this.rootDirectoryField.getText().endsWith(".class") || this.rootDirectoryField.getText().endsWith(".php") || this.rootDirectoryField.getText().endsWith(".java") || this.rootDirectoryField.getText().endsWith(".cpp") || this.rootDirectoryField.getText().endsWith(".c")) {
                    cpd.add(new File(this.rootDirectoryField.getText()));
                } else if (this.recurseCheckbox.isSelected()) {
                    cpd.addRecursively(this.rootDirectoryField.getText());
                } else {
                    cpd.addAllInDirectory(this.rootDirectoryField.getText());
                }
                final long start = System.currentTimeMillis();
                Timer t = new Timer(1000, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        long now = System.currentTimeMillis();
                        long elapsedMillis = now - start;
                        long elapsedSeconds = elapsedMillis / 1000L;
                        long hours = (long)Math.floor(elapsedSeconds / 3600L);
                        long minutes = (long)Math.floor((elapsedSeconds - hours * 3600L) / 60L);
                        long seconds = elapsedSeconds - (minutes * 60L + hours * 3600L);
                        GUI.this.timeField.setText("" + hours + ":" + minutes + ":" + seconds);
                    }
                });
                t.start();
                cpd.go();
                t.stop();
                String report = new SimpleRenderer().render(cpd.getMatches());
                if (report.length() == 0) {
                    JOptionPane.showMessageDialog(this.frame, "Done; couldn't find any duplicates longer than " + this.minimumLengthField.getText() + " tokens");
                    break block12;
                }
                this.resultsTextArea.setText(report);
            }
            catch (Throwable t) {
                t.printStackTrace();
                JOptionPane.showMessageDialog(this.frame, "Halted due to " + t.getClass().getName() + "; " + t.getMessage());
            }
        }
    }

    public void comparisonCountUpdate(long comparisons) {
        this.comparisonsField.setText(String.valueOf(comparisons));
    }

    public void addedFile(int fileCount, File file) {
        this.tokenizingFilesBar.setMaximum(fileCount);
        this.tokenizingFilesBar.setValue(this.tokenizingFilesBar.getValue() + 1);
    }

    public static void main(String[] args) {
        new GUI();
    }

    private class BrowseListener
    implements ActionListener {
        private BrowseListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(GUI.this.rootDirectoryField.getText());
            fc.setFileSelectionMode(2);
            fc.showDialog(GUI.this.frame, "Select");
            if (fc.getSelectedFile() != null) {
                GUI.this.rootDirectoryField.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            FileDialog fdlg = new FileDialog((Frame)GUI.this.frame, "Save", 1);
            fdlg.setVisible(true);
            String selected = fdlg.getDirectory() + System.getProperty("file.separator") + fdlg.getFile();
            if (selected != null) {
                if (!new File(selected).canWrite()) {
                    try {
                        PrintWriter pw = new PrintWriter(new FileOutputStream(selected));
                        String report = GUI.this.resultsTextArea.getText();
                        pw.print(report);
                        pw.flush();
                        pw.close();
                    }
                    catch (IOException e) {
                        this.error("Couldn't save file" + new File(selected).getAbsolutePath(), e);
                    }
                } else {
                    this.error("Could not write to file " + new File(selected).getAbsolutePath(), null);
                }
            }
        }

        private void error(String message, Exception e) {
            if (e != null) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(GUI.this.frame, message);
        }
    }

    private class GoListener
    implements ActionListener {
        private GoListener() {
        }

        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                public void run() {
                    GUI.this.tokenizingFilesBar.setValue(0);
                    GUI.this.tokenizingFilesBar.setString("");
                    GUI.this.resultsTextArea.setText("");
                    GUI.this.comparisonsField.setText("");
                    GUI.this.timeField.setText("");
                    GUI.this.go();
                }
            }).start();
        }
    }

    private static class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }
}

