/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd.cppast;

import java.util.Hashtable;
import net.sourceforge.pmd.cpd.cppast.ClassScope;
import net.sourceforge.pmd.cpd.cppast.Scope;

public class SymtabManager {
    static Hashtable scopeTable = new Hashtable();
    static Scope[] scopeStack = new Scope[100];
    static int depth = 0;

    public static Scope OpenScope(String scopeName, boolean isType) {
        Scope newScope;
        if (scopeName != null) {
            if (isType) {
                newScope = new ClassScope(scopeName, scopeStack[depth]);
                scopeStack[depth].PutTypeName(scopeName, newScope);
            } else {
                newScope = new Scope(scopeName, isType, scopeStack[depth]);
            }
            scopeTable.put(scopeName, newScope);
        } else {
            newScope = new Scope(scopeStack[depth]);
        }
        SymtabManager.scopeStack[++SymtabManager.depth] = newScope;
        return newScope;
    }

    public static void OpenScope(Scope sc) {
        SymtabManager.scopeStack[++SymtabManager.depth] = sc;
    }

    public static void PutTypeName(String name) {
        scopeStack[depth].PutTypeName(name);
    }

    public static boolean IsFullyScopedTypeName(String name) {
        if (name == null) {
            return false;
        }
        if (name.indexOf("::") == -1) {
            return SymtabManager.IsTypeName(name);
        }
        Scope sc = SymtabManager.GetScopeOfFullyScopedName(name);
        if (sc != null) {
            return sc.IsTypeName(name.substring(name.lastIndexOf("::") + 2, name.length()));
        }
        return false;
    }

    public static boolean IsTypeName(String name) {
        int i = depth;
        while (i >= 0) {
            if (!scopeStack[i--].IsTypeName(name)) continue;
            return true;
        }
        return false;
    }

    public static void CloseScope() {
        --depth;
    }

    public static boolean IsCtor(String name) {
        if (name == null) {
            return false;
        }
        if (name.indexOf("::") == -1) {
            return SymtabManager.GetScope(name) != null;
        }
        Scope sc = SymtabManager.GetScopeOfFullyScopedName(name);
        if (sc != null && sc.parent != null) {
            return sc.parent.GetScope(name.substring(name.lastIndexOf("::") + 2, name.length())) == sc;
        }
        return false;
    }

    public static Scope GetCurScope() {
        return scopeStack[depth];
    }

    public static Scope GetScope(String name) {
        int i = depth;
        Scope sc = null;
        while (i >= 0) {
            if ((sc = scopeStack[i--].GetScope(name)) == null) continue;
            return sc;
        }
        return null;
    }

    public static Scope GetScopeOfFullyScopedName(String name) {
        Scope sc;
        int i = 0;
        int j = 0;
        if (name.indexOf("::") == -1) {
            return SymtabManager.GetScope(name);
        }
        if (name.indexOf("::") == 0) {
            sc = scopeStack[1];
            j = 2;
        } else {
            sc = SymtabManager.GetCurScope();
        }
        String tmp = name.substring(j, name.lastIndexOf("::"));
        while ((j = tmp.indexOf("::", i)) != -1) {
            sc = sc.GetScope(tmp.substring(i, j));
            i = j + 2;
            if (sc != null) continue;
            return null;
        }
        if (sc == SymtabManager.GetCurScope()) {
            return SymtabManager.GetScope(tmp.substring(i, tmp.length()));
        }
        return sc.GetScope(tmp.substring(i, tmp.length()));
    }

    public static boolean IsGlobalScope() {
        return depth == 1 || depth == 2;
    }

    static {
        SymtabManager.scopeStack[SymtabManager.depth] = new Scope(null);
    }
}

