/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTAllocationExpression;
import net.sourceforge.pmd.ast.ASTArguments;
import net.sourceforge.pmd.ast.ASTArrayDimsAndInits;
import net.sourceforge.pmd.ast.ASTClassDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTNestedClassDeclaration;
import net.sourceforge.pmd.ast.ASTNestedInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.ast.ASTUnmodifiedClassDeclaration;

public class AccessorClassGenerationRule
extends AbstractRule {
    private int classID = -1;
    private List classDataList;
    private String packageName;

    private ClassData getCurrentClassData() {
        return (ClassData)this.classDataList.get(this.classID);
    }

    private void setClassID(int ID) {
        this.classID = ID;
    }

    private int getClassID() {
        return this.classID;
    }

    private String getPackageName() {
        return this.packageName;
    }

    private static String stripString(String remove, String value) {
        int index = value.indexOf(remove);
        String returnValue = index != -1 ? value.substring(0, index) + value.substring(index + remove.length()) : value;
        return returnValue;
    }

    public Object visit(ASTCompilationUnit node, Object data) {
        this.classDataList = new ArrayList();
        return super.visit(node, data);
    }

    private void processRule(RuleContext ctx) {
        Iterator outerIterator = this.classDataList.iterator();
        while (outerIterator.hasNext()) {
            ClassData outerDataSet = (ClassData)outerIterator.next();
            Iterator constructors = outerDataSet.getPrivateConstructorIterator();
            while (constructors.hasNext()) {
                ASTConstructorDeclaration cd = (ASTConstructorDeclaration)constructors.next();
                Iterator innerIterator = this.classDataList.iterator();
                while (innerIterator.hasNext()) {
                    ClassData innerDataSet = (ClassData)innerIterator.next();
                    if (outerDataSet == innerDataSet) continue;
                    Iterator allocations = innerDataSet.getInstantiationIterator();
                    while (allocations.hasNext()) {
                        AllocData ad = (AllocData)allocations.next();
                        if (!outerDataSet.getClassName().equals(ad.getName()) || cd.getParameterCount() != ad.getArgumentCount()) continue;
                        ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, ad.getASTAllocationExpression().getBeginLine()));
                    }
                }
            }
        }
    }

    public Object visit(ASTPackageDeclaration node, Object data) {
        this.packageName = ((ASTName)node.jjtGetChild(0)).getImage();
        return super.visit(node, data);
    }

    public Object visit(ASTInterfaceDeclaration node, Object data) {
        String className = node.getUnmodifedInterfaceDeclaration().getImage();
        this.classDataList.clear();
        this.setClassID(0);
        this.classDataList.add(this.getClassID(), new ClassData(className));
        Object o = super.visit(node, data);
        if (o != null) {
            this.processRule((RuleContext)o);
        } else {
            this.processRule((RuleContext)data);
        }
        this.setClassID(-1);
        return o;
    }

    public Object visit(ASTNestedInterfaceDeclaration node, Object data) {
        String className = node.getUnmodifedInterfaceDeclaration().getImage();
        int formerID = this.getClassID();
        this.setClassID(this.classDataList.size());
        ClassData newClassData = new ClassData(className);
        ClassData formerClassData = (ClassData)this.classDataList.get(formerID);
        newClassData.addClassQualifyingName(formerClassData.getClassName());
        this.classDataList.add(this.getClassID(), newClassData);
        Object o = super.visit(node, data);
        this.setClassID(formerID);
        return o;
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        String className = ((ASTUnmodifiedClassDeclaration)node.jjtGetChild(0)).getImage();
        this.classDataList.clear();
        this.setClassID(0);
        this.classDataList.add(this.getClassID(), new ClassData(className));
        Object o = super.visit(node, data);
        if (o != null) {
            this.processRule((RuleContext)o);
        } else {
            this.processRule((RuleContext)data);
        }
        this.setClassID(-1);
        return o;
    }

    public Object visit(ASTNestedClassDeclaration node, Object data) {
        String className = ((ASTUnmodifiedClassDeclaration)node.jjtGetChild(0)).getImage();
        int formerID = this.getClassID();
        this.setClassID(this.classDataList.size());
        ClassData newClassData = new ClassData(className);
        ClassData formerClassData = (ClassData)this.classDataList.get(formerID);
        newClassData.addClassQualifyingName(formerClassData.getClassName());
        this.classDataList.add(this.getClassID(), newClassData);
        Object o = super.visit(node, data);
        this.setClassID(formerID);
        return o;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        if (node.isPrivate()) {
            this.getCurrentClassData().addConstructor(node);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTAllocationExpression node, Object data) {
        AllocData ad = new AllocData(node, this.getPackageName(), this.getCurrentClassData().getClassQualifyingNamesList());
        if (!ad.isArray()) {
            this.getCurrentClassData().addInstantiation(ad);
        }
        return super.visit(node, data);
    }

    private static class AllocData {
        private String m_Name;
        private int m_ArgumentCount;
        private ASTAllocationExpression m_ASTAllocationExpression;
        private boolean isArray = false;

        public AllocData(ASTAllocationExpression node, String aPackageName, List classQualifyingNames) {
            if (node.jjtGetChild(1) instanceof ASTArguments) {
                ASTArguments aa = (ASTArguments)node.jjtGetChild(1);
                this.m_ArgumentCount = aa.getArgumentCount();
                ASTName an = (ASTName)node.jjtGetChild(0);
                this.m_Name = AccessorClassGenerationRule.stripString(aPackageName + ".", an.getImage());
                String findName = "";
                ListIterator li = classQualifyingNames.listIterator(classQualifyingNames.size());
                while (li.hasPrevious()) {
                    String aName = (String)li.previous();
                    findName = aName + "." + findName;
                    if (!this.m_Name.startsWith(findName)) continue;
                    this.m_Name = this.m_Name.substring(findName.length());
                    break;
                }
            } else if (node.jjtGetChild(1) instanceof ASTArrayDimsAndInits) {
                this.isArray = true;
            }
            this.m_ASTAllocationExpression = node;
        }

        public String getName() {
            return this.m_Name;
        }

        public int getArgumentCount() {
            return this.m_ArgumentCount;
        }

        public void show() {
            System.out.println("AllocData: " + this.getName() + " arguments= " + this.getArgumentCount());
        }

        public ASTAllocationExpression getASTAllocationExpression() {
            return this.m_ASTAllocationExpression;
        }

        public boolean isArray() {
            return this.isArray;
        }
    }

    private class ClassData {
        private String m_ClassName;
        private List m_PrivateConstructors;
        private List m_Instantiations;
        private List m_ClassQualifyingNames;

        public ClassData(String className) {
            this.m_ClassName = className;
            this.m_PrivateConstructors = new ArrayList();
            this.m_Instantiations = new ArrayList();
            this.m_ClassQualifyingNames = new ArrayList();
        }

        public void addInstantiation(AllocData ad) {
            this.m_Instantiations.add(ad);
        }

        public Iterator getInstantiationIterator() {
            return this.m_Instantiations.iterator();
        }

        public void addConstructor(ASTConstructorDeclaration cd) {
            this.m_PrivateConstructors.add(cd);
        }

        public Iterator getPrivateConstructorIterator() {
            return this.m_PrivateConstructors.iterator();
        }

        public String getClassName() {
            return this.m_ClassName;
        }

        public void addClassQualifyingName(String name) {
            this.m_ClassQualifyingNames.add(name);
        }

        public Iterator getClassQualifyingNames() {
            return this.m_ClassQualifyingNames.iterator();
        }

        public List getClassQualifyingNamesList() {
            return this.m_ClassQualifyingNames;
        }
    }
}

