/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

class ComponentFactory {
    ComponentFactory() {
    }

    protected static final JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        EmptyBorder emptyBorder = new EmptyBorder(3, 3, 3, 3);
        EtchedBorder etchedBorder = new EtchedBorder(0);
        CompoundBorder compoundBorder = new CompoundBorder(etchedBorder, emptyBorder);
        buttonPanel.setBorder(compoundBorder);
        return buttonPanel;
    }

    protected static final JButton createButton(String title) {
        return ComponentFactory.createButton(title, null, null);
    }

    protected static final JButton createButton(String title, Color background, Color foreground) {
        if (background == null) {
            background = UIManager.getColor("standardButtonBackground");
        }
        if (foreground == null) {
            foreground = UIManager.getColor("standardButtonForeground");
        }
        JButton button = new JButton(title);
        LineBorder lineBorder = new LineBorder(Color.DARK_GRAY, 1, true);
        BevelBorder bevelBorder = new BevelBorder(0);
        CompoundBorder compoundBorder = new CompoundBorder(bevelBorder, lineBorder);
        EtchedBorder etchedBorder = new EtchedBorder(1);
        compoundBorder = new CompoundBorder(etchedBorder, compoundBorder);
        compoundBorder = new CompoundBorder(lineBorder, compoundBorder);
        Dimension size = new Dimension(80, 30);
        button.setBackground(background);
        button.setForeground(foreground);
        button.setBorder(compoundBorder);
        button.setFont(UIManager.getFont("buttonFont"));
        button.setSize(size);
        button.setPreferredSize(size);
        button.setOpaque(true);
        return button;
    }

    protected static final JButton createSaveButton(ActionListener actionListener) {
        Color background = UIManager.getColor("pmdGreen");
        Color foreground = Color.white;
        JButton saveButton = ComponentFactory.createButton("Save", background, foreground);
        saveButton.addActionListener(actionListener);
        return saveButton;
    }

    protected static final JButton createCancelButton(ActionListener actionListener) {
        Color background = UIManager.getColor("pmdRed");
        Color foreground = Color.white;
        JButton cancelButton = ComponentFactory.createButton("Cancel", background, foreground);
        cancelButton.addActionListener(actionListener);
        return cancelButton;
    }

    protected static final JPanel createSaveCancelButtonPanel(ActionListener saveActionListener, ActionListener cancelActionListener) {
        JPanel buttonPanel = ComponentFactory.createButtonPanel();
        buttonPanel.add(ComponentFactory.createSaveButton(saveActionListener));
        buttonPanel.add(ComponentFactory.createCancelButton(cancelActionListener));
        return buttonPanel;
    }

    protected static final TitledBorder createTitledBorder(String title) {
        EtchedBorder etchedBorder = new EtchedBorder(1);
        CompoundBorder compoundBorder = new CompoundBorder(etchedBorder, etchedBorder);
        TitledBorder titledBorder = new TitledBorder(compoundBorder, title);
        titledBorder.setTitleFont(UIManager.getFont("titleFont"));
        titledBorder.setTitleColor(UIManager.getColor("pmdBlue"));
        titledBorder.setTitleJustification(1);
        return titledBorder;
    }

    protected static final JSplitPane createHorizontalSplitPane(Component leftPane, Component rightPane) {
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(1);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerSize(10);
        splitPane.setLeftComponent(leftPane);
        splitPane.setRightComponent(rightPane);
        splitPane.setOpaque(true);
        return splitPane;
    }

    protected static final JSplitPane createVerticalSplitPane(Component topPane, Component bottomPane) {
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerSize(10);
        splitPane.setTopComponent(topPane);
        splitPane.setBottomComponent(bottomPane);
        splitPane.setOpaque(true);
        return splitPane;
    }

    protected static final JScrollPane createScrollPane(Component view) {
        JScrollPane scrollPane = new JScrollPane(view);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.getViewport().setBackground(Color.white);
        scrollPane.setAutoscrolls(true);
        scrollPane.setBorder(new EtchedBorder(1));
        return scrollPane;
    }

    protected static final JTextArea createTextArea(String text) {
        JTextArea textArea = new JTextArea(text);
        BevelBorder bevelBorder = new BevelBorder(1);
        EmptyBorder emptyBorder = new EmptyBorder(3, 3, 3, 3);
        CompoundBorder compoundBorder = new CompoundBorder(bevelBorder, emptyBorder);
        textArea.setFont(UIManager.getFont("dataFont"));
        textArea.setBackground(Color.white);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setBorder(compoundBorder);
        textArea.setOpaque(true);
        return textArea;
    }

    protected static final Dimension adjustWindowSize(int windowWidth, int windowHeight) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (windowWidth >= screenSize.width) {
            windowWidth = screenSize.width - 10;
        }
        if (windowHeight >= screenSize.height) {
            windowHeight = screenSize.height - 20;
        }
        return new Dimension(windowWidth, windowHeight);
    }
}

