/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.pmd.swingui.PMDViewer;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.TextAnalysisResultsEvent;
import net.sourceforge.pmd.swingui.event.TextAnalysisResultsEventListener;

class PrintAnalysisResults {
    private PrintJob m_printJob;
    private Graphics m_graphics;
    private int m_printAreaX;
    private int m_printAreaY;
    private int m_printAreaWidth;
    private int m_printAreaHeight;
    private String m_analysisText;
    private String m_filePath;
    private String m_printDate;
    private int m_pageNumber;
    private int m_printLineTop;
    private Font m_font;
    private FontMetrics m_fontMetrics;
    private Font m_boldFont;
    private FontMetrics m_boldFontMetrics;
    private Font m_exampleFont;
    private FontMetrics m_exampleFontMetrics;
    private List m_lineTable;
    private final String EMPTY_STRING = "";
    private boolean m_printingExample;

    protected PrintAnalysisResults() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print() {
        GetAnalysisResults textListener = null;
        try {
            textListener = new GetAnalysisResults();
            ListenerList.addListener(textListener);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            PMDViewer viewer = PMDViewer.getViewer();
            String jobTitle = "Print Analysis Results";
            this.m_printJob = toolkit.getPrintJob(viewer, jobTitle, null);
            if (this.m_printJob != null) {
                int margin;
                TextAnalysisResultsEvent.notifyRequestText(this);
                Dimension pageSize = this.m_printJob.getPageDimension();
                int resolution = this.m_printJob.getPageResolution();
                this.m_printAreaX = margin = resolution / 2;
                this.m_printAreaY = margin;
                this.m_printAreaWidth = pageSize.width - margin - margin;
                this.m_printAreaHeight = pageSize.height - margin - margin;
                this.m_boldFont = new Font("Serif", 1, 9);
                this.m_boldFontMetrics = PMDViewer.getViewer().getFontMetrics(this.m_boldFont);
                this.m_font = new Font("Serif", 0, 9);
                this.m_fontMetrics = PMDViewer.getViewer().getFontMetrics(this.m_font);
                this.m_exampleFont = new Font("Courier", 0, 9);
                this.m_exampleFontMetrics = PMDViewer.getViewer().getFontMetrics(this.m_exampleFont);
                Date date = new Date();
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                this.m_printDate = dateFormat.format(date);
                this.buildLineTable();
                this.printAnalysisResults();
                this.m_lineTable.clear();
                this.m_printJob = null;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            ListenerList.removeListener(textListener);
            throw throwable;
        }
        ListenerList.removeListener(textListener);
    }

    private void buildLineTable() {
        StringTokenizer parser = new StringTokenizer(this.m_analysisText, "\n");
        this.m_lineTable = new ArrayList(1000);
        this.m_filePath = parser.nextToken();
        PrintLineInfo blankLine = new PrintLineInfo();
        blankLine.m_label = "";
        blankLine.m_data = "";
        blankLine.m_labelFont = this.m_boldFont;
        blankLine.m_labelFontMetrics = this.m_boldFontMetrics;
        blankLine.m_dataFont = this.m_font;
        blankLine.m_dataFontMetrics = this.m_fontMetrics;
        while (parser.hasMoreTokens()) {
            String textLine = parser.nextToken();
            boolean startingExample = false;
            if (textLine.startsWith("Example:")) {
                this.m_printingExample = true;
                startingExample = true;
            } else if (textLine.startsWith("Line:")) {
                this.m_printingExample = false;
                this.m_lineTable.add(blankLine);
                this.m_lineTable.add(blankLine);
                this.m_lineTable.add(blankLine);
            }
            this.buildPrintLineInfo(textLine, startingExample);
        }
    }

    private void buildPrintLineInfo(String textLine, boolean startingExample) {
        int printAreaRight;
        int dataAreaRight;
        PrintLineInfo printLineInfo = new PrintLineInfo();
        printLineInfo.m_label = "";
        printLineInfo.m_data = textLine;
        int index = textLine.indexOf(58);
        if (index >= 0) {
            printLineInfo.m_label = textLine.substring(0, ++index);
            String string = printLineInfo.m_data = index < textLine.length() ? textLine.substring(index) : "";
        }
        if (this.m_printingExample) {
            printLineInfo.m_dataFont = this.m_exampleFont;
            printLineInfo.m_dataFontMetrics = this.m_exampleFontMetrics;
            printLineInfo.m_label = "Example: ";
        } else {
            printLineInfo.m_dataFont = this.m_font;
            printLineInfo.m_dataFontMetrics = this.m_fontMetrics;
        }
        printLineInfo.m_labelFont = this.m_boldFont;
        printLineInfo.m_labelFontMetrics = this.m_boldFontMetrics;
        printLineInfo.m_labelWidth = printLineInfo.m_labelFontMetrics.stringWidth(printLineInfo.m_label);
        printLineInfo.m_dataWidth = printLineInfo.m_dataFontMetrics.stringWidth(printLineInfo.m_data);
        printLineInfo.m_labelX = this.m_printAreaX;
        printLineInfo.m_dataX = printLineInfo.m_labelX + printLineInfo.m_labelWidth;
        if (this.m_printingExample && !startingExample) {
            printLineInfo.m_label = "";
        }
        if ((dataAreaRight = printLineInfo.m_dataX + printLineInfo.m_dataWidth) <= (printAreaRight = this.m_printAreaX + this.m_printAreaWidth)) {
            this.m_lineTable.add(printLineInfo);
        } else {
            this.buildPrintLineInfoForMultipleLines(printLineInfo);
        }
    }

    private void buildPrintLineInfoForMultipleLines(PrintLineInfo basePrintLineInfo) {
        char[] data = basePrintLineInfo.m_data.toCharArray();
        int printAreaRight = this.m_printAreaX + this.m_printAreaWidth;
        int dataAreaWidth = printAreaRight - basePrintLineInfo.m_dataX;
        StringBuffer buffer = new StringBuffer(500);
        boolean createPrintLineInfo = false;
        int n = 0;
        while (n < data.length) {
            char theChar = data[n];
            buffer.append(theChar);
            if (theChar == ' ' || theChar == '\n') {
                String textLine = buffer.toString();
                if (this.m_fontMetrics.stringWidth(buffer.toString()) >= dataAreaWidth) {
                    int n1 = buffer.length() - 1;
                    while (n1 >= 0) {
                        if (buffer.charAt(n1) == ' ') {
                            textLine = textLine.substring(0, n1);
                            buffer.delete(0, n1 + 1);
                            break;
                        }
                        --n1;
                    }
                    createPrintLineInfo = true;
                } else if (theChar == '\n') {
                    buffer.setLength(0);
                    createPrintLineInfo = true;
                }
                if (createPrintLineInfo) {
                    PrintLineInfo printLineInfo = new PrintLineInfo();
                    printLineInfo.m_label = basePrintLineInfo.m_label;
                    printLineInfo.m_data = textLine;
                    printLineInfo.m_labelX = basePrintLineInfo.m_labelX;
                    printLineInfo.m_labelWidth = basePrintLineInfo.m_labelWidth;
                    printLineInfo.m_dataX = basePrintLineInfo.m_dataX;
                    printLineInfo.m_dataWidth = basePrintLineInfo.m_dataWidth;
                    printLineInfo.m_labelFont = basePrintLineInfo.m_labelFont;
                    printLineInfo.m_labelFontMetrics = basePrintLineInfo.m_labelFontMetrics;
                    printLineInfo.m_dataFont = basePrintLineInfo.m_dataFont;
                    printLineInfo.m_dataFontMetrics = basePrintLineInfo.m_dataFontMetrics;
                    this.m_lineTable.add(printLineInfo);
                    basePrintLineInfo.m_label = "";
                    createPrintLineInfo = false;
                }
            }
            ++n;
        }
        if (buffer.length() > 0) {
            PrintLineInfo printLineInfo = new PrintLineInfo();
            printLineInfo.m_label = basePrintLineInfo.m_label;
            printLineInfo.m_data = buffer.toString();
            printLineInfo.m_labelX = basePrintLineInfo.m_labelX;
            printLineInfo.m_labelWidth = basePrintLineInfo.m_labelWidth;
            printLineInfo.m_dataX = basePrintLineInfo.m_dataX;
            printLineInfo.m_dataWidth = basePrintLineInfo.m_dataWidth;
            printLineInfo.m_labelFont = basePrintLineInfo.m_labelFont;
            printLineInfo.m_labelFontMetrics = basePrintLineInfo.m_labelFontMetrics;
            printLineInfo.m_dataFont = basePrintLineInfo.m_dataFont;
            printLineInfo.m_dataFontMetrics = basePrintLineInfo.m_dataFontMetrics;
            this.m_lineTable.add(printLineInfo);
        }
    }

    private void printAnalysisResults() {
        Iterator lineTableIterator = this.m_lineTable.iterator();
        this.m_printLineTop = this.m_printAreaY + this.m_printAreaHeight;
        int lineHeight = this.m_fontMetrics.getHeight();
        int printAreaBottom = this.m_printAreaY + this.m_printAreaHeight;
        while (lineTableIterator.hasNext()) {
            PrintLineInfo printLineInfo = (PrintLineInfo)lineTableIterator.next();
            if (this.m_printLineTop + lineHeight > printAreaBottom) {
                this.endPage();
                this.beginPage();
                this.printHeader();
            }
            this.printBody(printLineInfo);
        }
        this.m_printJob.end();
    }

    private void beginPage() {
        this.m_graphics = this.m_printJob.getGraphics();
    }

    private void printHeader() {
        this.m_printLineTop = this.m_printAreaY;
        int baseline = this.m_printLineTop + this.m_boldFontMetrics.getAscent();
        this.m_graphics.setFont(this.m_boldFont);
        int fileNameX = this.m_printAreaX;
        int fileNameWidth = this.m_boldFontMetrics.stringWidth(this.m_filePath);
        this.m_graphics.drawString(this.m_filePath, fileNameX, baseline);
        ++this.m_pageNumber;
        String pageText = "Page " + this.m_pageNumber;
        int pageTextWidth = this.m_boldFontMetrics.stringWidth(pageText);
        int pageTextX = this.m_printAreaX + this.m_printAreaWidth / 2 - pageTextWidth / 2;
        if (pageTextX <= this.m_printAreaX + fileNameWidth) {
            pageTextX = this.m_printAreaX + fileNameWidth + 10;
        }
        this.m_graphics.drawString(pageText, pageTextX, baseline);
        int printDateWidth = this.m_boldFontMetrics.stringWidth(this.m_printDate);
        int printDateX = this.m_printAreaX + this.m_printAreaWidth - printDateWidth;
        this.m_graphics.drawString(this.m_printDate, printDateX, baseline);
        this.m_printLineTop += this.m_boldFontMetrics.getHeight() + 3;
        int x1 = this.m_printAreaX;
        int x2 = this.m_printAreaX + this.m_printAreaWidth;
        this.m_graphics.drawLine(x1, this.m_printLineTop, x2, this.m_printLineTop);
        this.m_printLineTop += 3;
    }

    private void printBody(PrintLineInfo printLineInfo) {
        if (printLineInfo.m_label.length() > 0 || printLineInfo.m_data.length() > 0) {
            int y;
            int x;
            int baseline = this.m_printLineTop + printLineInfo.m_labelFontMetrics.getAscent();
            if (printLineInfo.m_label.length() > 0) {
                this.m_graphics.setFont(printLineInfo.m_labelFont);
                x = printLineInfo.m_labelX;
                y = baseline;
                this.m_graphics.drawString(printLineInfo.m_label, x, y);
            }
            this.m_graphics.setFont(printLineInfo.m_dataFont);
            x = printLineInfo.m_dataX;
            y = baseline;
            this.m_graphics.drawString(printLineInfo.m_data, x, y);
        }
        this.m_printLineTop += printLineInfo.m_dataFontMetrics.getHeight();
    }

    private void endPage() {
        this.m_graphics = null;
    }

    private class PrintLineInfo {
        public String m_label;
        public String m_data;
        public int m_labelWidth;
        public int m_dataWidth;
        public int m_labelX;
        public int m_dataX;
        public Font m_labelFont;
        public FontMetrics m_labelFontMetrics;
        public Font m_dataFont;
        public FontMetrics m_dataFontMetrics;

        private PrintLineInfo() {
        }
    }

    private class GetAnalysisResults
    implements TextAnalysisResultsEventListener {
        private GetAnalysisResults() {
        }

        public void requestTextAnalysisResults(TextAnalysisResultsEvent event) {
        }

        public void returnedTextAnalysisResults(TextAnalysisResultsEvent event) {
            PrintAnalysisResults.this.m_analysisText = event.getText();
        }
    }
}

