/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLEditorKit;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.swingui.HTMLResultRenderer;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.PMDViewer;
import net.sourceforge.pmd.swingui.TextRenderer;
import net.sourceforge.pmd.swingui.event.HTMLAnalysisResultsEvent;
import net.sourceforge.pmd.swingui.event.HTMLAnalysisResultsEventListener;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.StatusBarEvent;
import net.sourceforge.pmd.swingui.event.TextAnalysisResultsEvent;
import net.sourceforge.pmd.swingui.event.TextAnalysisResultsEventListener;

abstract class ResultsViewer
extends JEditorPane {
    private File[] m_sourceFiles;
    private String m_htmlText;
    private PMD m_pmd;
    private RuleSet m_ruleSet;

    protected ResultsViewer() {
        this.setEditorKit(new HTMLEditorKit());
        this.setEditable(false);
        this.setBackground(UIManager.getColor("pmdGray"));
        this.m_pmd = new PMD();
        this.m_ruleSet = new RuleSet();
        ListenerList.addListener(new HTMLAnalysisResultsEventHandler());
        ListenerList.addListener(new TextAnalysisResultsEventHandler());
    }

    private void scrollToTop() {
        Container component = this.getParent();
        while (!(component instanceof JScrollPane)) {
            component = component.getParent();
        }
        if (component != null) {
            JScrollPane parentScrollPane = (JScrollPane)component;
            parentScrollPane.getHorizontalScrollBar().setValue(0);
            parentScrollPane.getVerticalScrollBar().setValue(0);
            parentScrollPane.repaint();
        }
    }

    protected String getHTMLText(File file) {
        return this.m_htmlText;
    }

    protected String getHTMLText() {
        return this.m_htmlText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getPlainText() {
        String fullText = "";
        if (this.m_sourceFiles == null) return fullText;
        File[] fileArray = this.m_sourceFiles;
        synchronized (this.m_sourceFiles) {
            try {
                RuleContext ruleContext = new RuleContext();
                TextRenderer renderer = new TextRenderer();
                renderer.beginRendering(this.m_sourceFiles.length == 1);
                int n = 0;
                while (n < this.m_sourceFiles.length) {
                    ruleContext.setSourceCodeFilename(this.m_sourceFiles[n].getPath());
                    ruleContext.setReport(new Report());
                    this.m_pmd.processFile(new FileInputStream(this.m_sourceFiles[n]), this.m_ruleSet, ruleContext);
                    String filePath = this.m_sourceFiles[n].getPath();
                    Report report = ruleContext.getReport();
                    renderer.render(filePath, report);
                    ++n;
                }
                return renderer.endRendering();
            }
            catch (FileNotFoundException exception) {
                MessageDialog.show(PMDViewer.getViewer(), null, exception);
            }
            catch (PMDException pmdException) {
                String message = pmdException.getMessage();
                Exception exception = pmdException.getReason();
                MessageDialog.show(PMDViewer.getViewer(), message, exception);
            }
            return fullText;
        }
    }

    protected void analyze() {
        if (this.m_sourceFiles != null && this.m_ruleSet != null) {
            new AnalyzeThread().start();
        }
    }

    protected void analyze(File[] selectedFile, RuleSet ruleSet) {
        if (selectedFile != null && ruleSet != null) {
            this.m_sourceFiles = selectedFile;
            this.m_ruleSet = ruleSet;
            new AnalyzeThread().start();
        }
    }

    private class TextAnalysisResultsEventHandler
    implements TextAnalysisResultsEventListener {
        private TextAnalysisResultsEventHandler() {
        }

        public void requestTextAnalysisResults(TextAnalysisResultsEvent event) {
            TextAnalysisResultsEvent.notifyReturnedText(this, ResultsViewer.this.getPlainText());
        }

        public void returnedTextAnalysisResults(TextAnalysisResultsEvent event) {
        }
    }

    private class HTMLAnalysisResultsEventHandler
    implements HTMLAnalysisResultsEventListener {
        private HTMLAnalysisResultsEventHandler() {
        }

        public void requestHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
            if (ResultsViewer.this.m_htmlText == null) {
                ResultsViewer.this.m_htmlText = "";
            }
            HTMLAnalysisResultsEvent.notifyReturnedHTMLText(this, ResultsViewer.this.m_htmlText);
        }

        public void returnedHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
        }
    }

    private class AnalyzeThread
    extends Thread {
        private ResultsViewer m_resultsViewer;

        private AnalyzeThread() {
            super("Analyze");
            this.m_resultsViewer = ResultsViewer.this;
        }

        public void run() {
            this.setup();
            this.process();
            this.cleanup();
        }

        protected void setup() {
            PMDViewer.getViewer().setEnableViewer(false);
            StatusBarEvent.notifyStartAnimation(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void process() {
            if (ResultsViewer.this.m_sourceFiles == null) {
                return;
            }
            try {
                try {
                    StatusBarEvent.notifyShowMessage(this, "Analyzing.  Please wait...");
                    RuleContext ruleContext = new RuleContext();
                    HTMLResultRenderer renderer = new HTMLResultRenderer();
                    boolean reportNoViolations = ResultsViewer.this.m_sourceFiles.length == 1;
                    renderer.beginRendering(reportNoViolations);
                    int n = 0;
                    while (true) {
                        if (n >= ResultsViewer.this.m_sourceFiles.length) {
                            ResultsViewer.this.m_htmlText = renderer.endRendering();
                            StatusBarEvent.notifyShowMessage(this, "Storing HTML page into viewer.  Please wait...");
                            ResultsViewer.this.setText(ResultsViewer.this.m_htmlText);
                            break;
                        }
                        ruleContext.setSourceCodeFilename(ResultsViewer.this.m_sourceFiles[n].getPath());
                        ruleContext.setReport(new Report());
                        ResultsViewer.this.m_pmd.processFile(new FileInputStream(ResultsViewer.this.m_sourceFiles[n]), ResultsViewer.this.m_ruleSet, ruleContext);
                        StatusBarEvent.notifyShowMessage(this, "Rendering analysis results into HTML page.  Please wait...");
                        String filePath = ResultsViewer.this.m_sourceFiles[n].getPath();
                        Report report = ruleContext.getReport();
                        renderer.render(filePath, report);
                        ++n;
                    }
                }
                catch (FileNotFoundException exception) {
                    MessageDialog.show(PMDViewer.getViewer(), null, exception);
                    Object var8_13 = null;
                    this.m_resultsViewer.scrollToTop();
                    StatusBarEvent.notifyShowMessage(this, "Finished");
                    return;
                }
                catch (PMDException pmdException) {
                    String message = pmdException.getMessage();
                    Exception exception = pmdException.getReason();
                    MessageDialog.show(PMDViewer.getViewer(), message, exception);
                    Object var8_14 = null;
                    this.m_resultsViewer.scrollToTop();
                    StatusBarEvent.notifyShowMessage(this, "Finished");
                    return;
                }
                catch (OutOfMemoryError error) {
                    MessageDialog.show(PMDViewer.getViewer(), "Out of memory.");
                    Object var8_15 = null;
                    this.m_resultsViewer.scrollToTop();
                    StatusBarEvent.notifyShowMessage(this, "Finished");
                    return;
                }
                Object var8_12 = null;
            }
            catch (Throwable throwable) {
                Object var8_16 = null;
                this.m_resultsViewer.scrollToTop();
                StatusBarEvent.notifyShowMessage(this, "Finished");
                throw throwable;
            }
            this.m_resultsViewer.scrollToTop();
            StatusBarEvent.notifyShowMessage(this, "Finished");
        }

        protected void cleanup() {
            StatusBarEvent.notifyStopAnimation(this);
            PMDViewer.getViewer().setEnableViewer(true);
        }
    }
}

