/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.sourceforge.pmd.swingui.ComponentFactory;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.RulesTreeNode;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.RulesEditingEvent;
import net.sourceforge.pmd.swingui.event.RulesEditingEventListener;

class RuleSetEditingPanel
extends JPanel {
    private JLabel m_nameLabel;
    private JTextField m_name;
    private JLabel m_descriptionLabel;
    private JTextArea m_description;
    private JScrollPane m_descriptionScrollPane;
    private boolean m_enabled;
    private RulesTreeNode m_currentDataNode;
    private boolean m_isEditing;
    private String m_originalName;
    private FocusListener m_focusListener = new RuleSetNameFocusListener();

    protected RuleSetEditingPanel() {
        super(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        this.setBorder(emptyBorder);
        int[] columnWidths = new int[]{25, 100, 100, 100, 100, 100};
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = columnWidths;
        JPanel panel = new JPanel(layout);
        TitledBorder titledBorder = ComponentFactory.createTitledBorder("  Rule Set  ");
        panel.setBorder(titledBorder);
        this.add((Component)panel, "Center");
        this.m_nameLabel = new JLabel("Name");
        this.m_nameLabel.setFont(UIManager.getFont("labelFont"));
        this.m_nameLabel.setHorizontalAlignment(4);
        GridBagConstraints constraints = layout.getConstraints(this.m_nameLabel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_nameLabel, constraints);
        this.m_name = new JTextField();
        this.m_name.setFont(UIManager.getFont("dataFont"));
        this.m_name.addFocusListener(this.m_focusListener);
        this.m_name.setRequestFocusEnabled(true);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_name, constraints);
        this.m_descriptionLabel = new JLabel("Description");
        this.m_descriptionLabel.setFont(UIManager.getFont("labelFont"));
        this.m_descriptionLabel.setHorizontalAlignment(4);
        constraints = layout.getConstraints(this.m_nameLabel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_descriptionLabel, constraints);
        this.m_description = ComponentFactory.createTextArea("");
        this.m_descriptionScrollPane = ComponentFactory.createScrollPane(this.m_description);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(4, 2, 4, 2);
        constraints.ipady = 80;
        panel.add((Component)this.m_descriptionScrollPane, constraints);
        this.enableData(false);
        ListenerList.addListener(new RulesEditingEventHandler());
    }

    private void saveData(RulesTreeNode dataNode) {
        if (dataNode != null && this.m_isEditing && (dataNode.isRuleSet() || dataNode.isRule() || dataNode.isProperty())) {
            String ruleSetName = this.m_name.getText();
            if (ruleSetName.length() == 0) {
                String message = "The rule set name is missing.  The change will not be applied.";
                boolean hasFocus = this.m_name.hasFocus();
                this.m_name.removeFocusListener(this.m_focusListener);
                MessageDialog.show(this.getParentWindow(), message);
                this.m_name.addFocusListener(this.m_focusListener);
                if (hasFocus) {
                    this.m_name.requestFocus();
                }
                ruleSetName = this.m_originalName;
            } else if (!ruleSetName.equalsIgnoreCase(this.m_originalName) && dataNode.getSibling(ruleSetName) != null) {
                String template = "Another rule set already has the name \"{0}\".  The change will not be applied.";
                Object[] args = new String[]{ruleSetName};
                String message = MessageFormat.format(template, args);
                boolean hasFocus = this.m_name.hasFocus();
                this.m_name.removeFocusListener(this.m_focusListener);
                MessageDialog.show(this.getParentWindow(), message);
                this.m_name.addFocusListener(this.m_focusListener);
                if (hasFocus) {
                    this.m_name.requestFocus();
                }
                ruleSetName = this.m_originalName;
            }
            dataNode.setName(ruleSetName);
            dataNode.setDescription(this.m_description.getText());
        }
    }

    protected void setIsEditing(boolean isEditing) {
        this.m_isEditing = isEditing;
    }

    private void loadData(RulesTreeNode dataNode) {
        if (dataNode == null) {
            this.enableData(false);
        } else if (dataNode.isRuleSet()) {
            this.loadData_(dataNode);
        } else if (dataNode.isRule()) {
            this.loadData_(dataNode.getParentRuleSetData());
        } else if (dataNode.isProperty()) {
            this.loadData_(dataNode.getParentRuleSetData());
        } else {
            this.enableData(false);
        }
    }

    private void loadData_(RulesTreeNode dataNode) {
        if (!this.m_enabled) {
            this.enableData(true);
        }
        this.m_name.setText(dataNode.getName());
        this.m_description.setText(dataNode.getDescription());
        this.m_originalName = dataNode.getName();
        this.m_currentDataNode = dataNode;
    }

    private void enableData(boolean enable) {
        if (enable) {
            this.m_name.removeFocusListener(this.m_focusListener);
            this.m_name.addFocusListener(this.m_focusListener);
            this.m_nameLabel.setEnabled(true);
            this.m_name.setEnabled(true);
            this.m_name.setBackground(Color.white);
            this.m_descriptionLabel.setEnabled(true);
            this.m_description.setEnabled(true);
            this.m_description.setBackground(Color.white);
        } else {
            this.m_name.removeFocusListener(this.m_focusListener);
            Color background = UIManager.getColor("disabledTextBackground");
            this.m_nameLabel.setEnabled(false);
            this.m_name.setText("");
            this.m_name.setEnabled(false);
            this.m_name.setBackground(background);
            this.m_descriptionLabel.setEnabled(false);
            this.m_description.setText("");
            this.m_description.setEnabled(false);
            this.m_description.setBackground(background);
            this.m_currentDataNode = null;
        }
        this.m_enabled = enable;
    }

    private Window getParentWindow() {
        Container component = this.getParent();
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    private class RulesEditingEventHandler
    implements RulesEditingEventListener {
        private RulesEditingEventHandler() {
        }

        public void loadData(RulesEditingEvent event) {
            RuleSetEditingPanel.this.loadData(event.getDataNode());
        }

        public void saveData(RulesEditingEvent event) {
            RuleSetEditingPanel.this.saveData(event.getDataNode());
        }
    }

    private class RuleSetNameFocusListener
    implements FocusListener {
        private RuleSetNameFocusListener() {
        }

        public void focusGained(FocusEvent event) {
        }

        public void focusLost(FocusEvent event) {
            String ruleSetName = RuleSetEditingPanel.this.m_name.getText().trim();
            if (ruleSetName.length() == 0) {
                String message = "The rule set name is missing.";
                RuleSetEditingPanel.this.m_name.removeFocusListener(this);
                MessageDialog.show(RuleSetEditingPanel.this.getParentWindow(), message);
                RuleSetEditingPanel.this.m_name.addFocusListener(this);
                RuleSetEditingPanel.this.m_name.requestFocus();
            } else if (!ruleSetName.equalsIgnoreCase(RuleSetEditingPanel.this.m_originalName) && RuleSetEditingPanel.this.m_currentDataNode.getSibling(ruleSetName) != null) {
                String template = "Another rule set already has the name \"{0}\".";
                Object[] args = new String[]{ruleSetName};
                String message = MessageFormat.format(template, args);
                RuleSetEditingPanel.this.m_name.removeFocusListener(this);
                MessageDialog.show(RuleSetEditingPanel.this.getParentWindow(), message);
                RuleSetEditingPanel.this.m_name.addFocusListener(this);
                RuleSetEditingPanel.this.m_name.requestFocus();
            }
        }
    }
}

