/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import net.sourceforge.pmd.PMDDirectory;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.swingui.ComponentFactory;
import net.sourceforge.pmd.swingui.DirectoryTable;
import net.sourceforge.pmd.swingui.DirectoryTree;
import net.sourceforge.pmd.swingui.DirectoryTreeModel;
import net.sourceforge.pmd.swingui.PMDViewer;

class RulesClassSelectDialog
extends JDialog {
    private DirectoryTree m_tree;
    private DirectoryTable m_table;
    private JSplitPane m_splitPane;
    private JScrollPane m_treeScrollPane;
    private JScrollPane m_tableScrollPane;
    private File m_selectedClassFile;
    private boolean m_selectWasPressed;

    protected RulesClassSelectDialog(JFrame parentWindow) throws PMDException {
        super(parentWindow, "Rules Class File Selector", true);
        this.setSize(ComponentFactory.adjustWindowSize(1200, 800));
        this.setLocationRelativeTo(PMDViewer.getViewer());
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.createDirectoryTreeScrollPane();
        this.createDirectoryTableScrollPane();
        this.createDirectorySplitPane();
        this.buildTree();
        JPanel buttonPanel = this.createButtonPanel();
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this.m_splitPane, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(contentPanel);
    }

    private void createDirectoryTreeScrollPane() {
        this.m_tree = new DirectoryTree("Rules Repository");
        this.m_treeScrollPane = ComponentFactory.createScrollPane(this.m_tree);
        Color background = UIManager.getColor("pmdTreeBackground");
        this.m_treeScrollPane.getViewport().setBackground(background);
    }

    private void createDirectoryTableScrollPane() {
        this.m_table = new DirectoryTable(this.m_tree, ".class");
        this.m_tableScrollPane = ComponentFactory.createScrollPane(this.m_table);
        Color background = UIManager.getColor("pmdTableBackground");
        this.m_tableScrollPane.getViewport().setBackground(background);
    }

    private void createDirectorySplitPane() {
        this.m_splitPane = ComponentFactory.createHorizontalSplitPane(this.m_treeScrollPane, this.m_tableScrollPane);
    }

    private void buildTree() throws PMDException {
        PMDDirectory pmdDirectory = PMDDirectory.getDirectory();
        String rulesDirectoryPath = pmdDirectory.getRuleSetsDirectoryPath();
        File[] rulesDirectory = new File[]{new File(rulesDirectoryPath)};
        ((DirectoryTreeModel)this.m_tree.getModel()).setupFiles(rulesDirectory);
        this.m_tree.expandRootNode();
    }

    private JPanel createButtonPanel() {
        SelectButtonActionListener selectActionListener = new SelectButtonActionListener();
        CancelButtonActionListener cancelActionListener = new CancelButtonActionListener();
        JPanel buttonPanel = ComponentFactory.createButtonPanel();
        JButton selectButton = ComponentFactory.createSaveButton(selectActionListener);
        JButton cancelButton = ComponentFactory.createCancelButton(cancelActionListener);
        selectButton.setText("Select");
        buttonPanel.add(selectButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    protected File getSelectedClassFile() {
        return this.m_selectedClassFile;
    }

    protected boolean selectWasPressed() {
        return this.m_selectWasPressed;
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            RulesClassSelectDialog.this.setVisible(false);
        }
    }

    private class SelectButtonActionListener
    implements ActionListener {
        private SelectButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            RulesClassSelectDialog.this.m_selectWasPressed = true;
            RulesClassSelectDialog.this.m_selectedClassFile = RulesClassSelectDialog.this.m_table.getSelectedFile();
            RulesClassSelectDialog.this.setVisible(false);
        }
    }
}

