/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.ArrayList;
import net.sourceforge.pmd.symboltable.AbstractScope;
import net.sourceforge.pmd.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.NameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.util.Applier;

public class ClassScope
extends AbstractScope {
    private String className;

    public ClassScope(String className) {
        this.className = className;
    }

    public Scope getEnclosingClassScope() {
        return this;
    }

    public void addDeclaration(MethodNameDeclaration decl) {
        this.methodNames.put(decl, new ArrayList());
    }

    protected NameDeclaration findVariableHere(NameOccurrence occurrence) {
        if (occurrence.isThisOrSuper() || occurrence.getImage().equals(this.className)) {
            if (this.variableNames.isEmpty()) {
                return null;
            }
            return (NameDeclaration)this.variableNames.keySet().iterator().next();
        }
        ArrayList<String> images = new ArrayList<String>();
        images.add(occurrence.getImage());
        if (occurrence.getImage().startsWith(this.className)) {
            images.add(this.clipClassName(occurrence.getImage()));
        }
        ImageFinderFunction finder = new ImageFinderFunction(images);
        Applier.apply(finder, this.variableNames.keySet().iterator());
        return finder.getDecl();
    }

    public String toString() {
        return "ClassScope:" + super.glomNames();
    }

    private String clipClassName(String in) {
        int firstDot = in.indexOf(46);
        return in.substring(firstDot + 1);
    }
}

