/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeSet {
    private String pkg;
    private Set imports = new HashSet();
    private List resolvers = new ArrayList();

    public void setASTCompilationUnitPackage(String pkg) {
        this.pkg = pkg;
    }

    public String getASTCompilationUnitPackage() {
        return this.pkg;
    }

    public void addImport(String importString) {
        this.imports.add(importString);
    }

    public int getImportsCount() {
        return this.imports.size();
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (this.resolvers.isEmpty()) {
            this.buildResolvers();
        }
        Iterator i = this.resolvers.iterator();
        while (i.hasNext()) {
            Resolver resolver = (Resolver)i.next();
            try {
                return resolver.resolve(name);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Type " + name + " not found");
    }

    private void buildResolvers() {
        this.resolvers.add(new PrimitiveTypeResolver());
        this.resolvers.add(new VoidResolver());
        this.resolvers.add(new ExplicitImportResolver(this.imports));
        this.resolvers.add(new CurrentPackageResolver(this.pkg));
        this.resolvers.add(new ImplicitImportResolver());
        this.resolvers.add(new ImportOnDemandResolver(this.imports));
        this.resolvers.add(new FullyQualifiedNameResolver());
    }

    public static class FullyQualifiedNameResolver
    implements Resolver {
        public Class resolve(String name) throws ClassNotFoundException {
            return Class.forName(name);
        }
    }

    public static class VoidResolver
    implements Resolver {
        public Class resolve(String name) throws ClassNotFoundException {
            if (name.equals("void")) {
                return Void.TYPE;
            }
            throw new ClassNotFoundException();
        }
    }

    public static class PrimitiveTypeResolver
    implements Resolver {
        private Map primitiveTypes = new HashMap();

        public PrimitiveTypeResolver() {
            this.primitiveTypes.put("int", Integer.TYPE);
            this.primitiveTypes.put("float", Float.TYPE);
            this.primitiveTypes.put("double", Double.TYPE);
            this.primitiveTypes.put("long", Long.TYPE);
            this.primitiveTypes.put("boolean", Boolean.TYPE);
            this.primitiveTypes.put("byte", Byte.TYPE);
            this.primitiveTypes.put("short", Short.TYPE);
            this.primitiveTypes.put("char", Character.TYPE);
        }

        public Class resolve(String name) throws ClassNotFoundException {
            if (!this.primitiveTypes.containsKey(name)) {
                throw new ClassNotFoundException();
            }
            return (Class)this.primitiveTypes.get(name);
        }
    }

    public static class ImportOnDemandResolver
    implements Resolver {
        private Set importStmts;

        public ImportOnDemandResolver(Set importStmts) {
            this.importStmts = importStmts;
        }

        public Class resolve(String name) throws ClassNotFoundException {
            Iterator i = this.importStmts.iterator();
            while (i.hasNext()) {
                String importStmt = (String)i.next();
                if (!importStmt.endsWith("*")) continue;
                try {
                    String importPkg = importStmt.substring(0, importStmt.indexOf("*") - 1);
                    return Class.forName(importPkg + "." + name);
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException("Type " + name + " not found");
        }
    }

    public static class ImplicitImportResolver
    implements Resolver {
        public Class resolve(String name) throws ClassNotFoundException {
            return Class.forName("java.lang." + name);
        }
    }

    public static class CurrentPackageResolver
    implements Resolver {
        private String pkg;

        public CurrentPackageResolver(String pkg) {
            this.pkg = pkg;
        }

        public Class resolve(String name) throws ClassNotFoundException {
            return Class.forName(this.pkg + name);
        }
    }

    public static class ExplicitImportResolver
    implements Resolver {
        private Set importStmts;

        public ExplicitImportResolver(Set importStmts) {
            this.importStmts = importStmts;
        }

        public Class resolve(String name) throws ClassNotFoundException {
            Iterator i = this.importStmts.iterator();
            while (i.hasNext()) {
                String importStmt = (String)i.next();
                if (!importStmt.endsWith(name)) continue;
                return Class.forName(importStmt);
            }
            throw new ClassNotFoundException("Type " + name + " not found");
        }
    }

    public static interface Resolver {
        public Class resolve(String var1) throws ClassNotFoundException;
    }
}

