/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import test.net.sourceforge.pmd.ast.ParserTst;

public class FieldDeclTest
extends ParserTst {
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTFieldDeclaration;

    public String makeAccessJavaCode(String[] access) {
        String RC = "public class Test { ";
        int i = 0;
        while (i < access.length) {
            RC = RC + access[i] + " ";
            ++i;
        }
        RC = RC + " int j;  }";
        return RC;
    }

    public ASTFieldDeclaration getFieldDecl(String[] access) throws Throwable {
        Set fields = this.getNodes(class$net$sourceforge$pmd$ast$ASTFieldDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTFieldDeclaration = FieldDeclTest.class$("net.sourceforge.pmd.ast.ASTFieldDeclaration")) : class$net$sourceforge$pmd$ast$ASTFieldDeclaration, this.makeAccessJavaCode(access));
        Assert.assertEquals((String)"Wrong number of fields", (int)1, (int)fields.size());
        Iterator i = fields.iterator();
        return (ASTFieldDeclaration)i.next();
    }

    public void testPublic() throws Throwable {
        String[] access = new String[]{"public"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be public.", (boolean)afd.isPublic());
    }

    public void testProtected() throws Throwable {
        String[] access = new String[]{"protected"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be protected.", (boolean)afd.isProtected());
    }

    public void testPrivate() throws Throwable {
        String[] access = new String[]{"private"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be private.", (boolean)afd.isPrivate());
    }

    public void testStatic() throws Throwable {
        String[] access = new String[]{"private", "static"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be static.", (boolean)afd.isStatic());
        Assert.assertTrue((String)"Expecting field to be private.", (boolean)afd.isPrivate());
    }

    public void testFinal() throws Throwable {
        String[] access = new String[]{"public", "final"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be final.", (boolean)afd.isFinal());
        Assert.assertTrue((String)"Expecting field to be public.", (boolean)afd.isPublic());
    }

    public void testTransient() throws Throwable {
        String[] access = new String[]{"private", "transient"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be private.", (boolean)afd.isPrivate());
        Assert.assertTrue((String)"Expecting field to be transient.", (boolean)afd.isTransient());
    }

    public void testVolatile() throws Throwable {
        String[] access = new String[]{"private", "volatile"};
        ASTFieldDeclaration afd = this.getFieldDecl(access);
        Assert.assertTrue((String)"Expecting field to be volatile.", (boolean)afd.isVolatile());
        Assert.assertTrue((String)"Expecting field to be private.", (boolean)afd.isPrivate());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

