/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.cpd.FileReporter;
import net.sourceforge.pmd.cpd.ReportException;

public class FileReporterTest
extends TestCase {
    public void testCreation() {
        try {
            FileReporter fileReporter = new FileReporter(null);
            Assert.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException npe) {}
    }

    public void testEmptyReport() throws ReportException {
        File reportFile = new File("report.tmp");
        FileReporter fileReporter = new FileReporter(reportFile);
        fileReporter.report("");
        Assert.assertTrue((boolean)reportFile.exists());
        Assert.assertEquals((long)0L, (long)reportFile.length());
        Assert.assertTrue((boolean)reportFile.delete());
    }

    public void testReport() throws ReportException, IOException {
        String testString = "first line\nsecond line";
        File reportFile = new File("report.tmp");
        FileReporter fileReporter = new FileReporter(reportFile);
        fileReporter.report(testString);
        Assert.assertEquals((String)testString, (String)this.readFile(reportFile));
        Assert.assertTrue((boolean)reportFile.delete());
    }

    public void testInvalidFile() {
        File reportFile = new File("/invalid_folder/report.tmp");
        FileReporter fileReporter = new FileReporter(reportFile);
        try {
            fileReporter.report("");
            Assert.fail((String)"expected ReportException");
        }
        catch (ReportException re) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        String string;
        block3: {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                StringBuffer buffer = new StringBuffer();
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                    if (line == null) continue;
                    buffer.append("\n");
                }
                string = buffer.toString();
                Object var7_6 = null;
                if (reader == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_7 = null;
                    if (reader == null) break block4;
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        return string;
    }
}

