/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.rules;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.rules.XPathRule;
import test.net.sourceforge.pmd.rules.SimpleAggregatorTst;
import test.net.sourceforge.pmd.rules.TestDescriptor;

public class FinalFieldCouldBeStaticRuleTest
extends SimpleAggregatorTst {
    private Rule rule;
    private static final String TEST1 = "public class Foo {" + CPD.EOL + " public final int BAR = 42;" + CPD.EOL + "}";
    private static final String TEST2 = "public class Foo {" + CPD.EOL + " public static final int BAR = 42;" + CPD.EOL + "}";
    private static final String TEST3 = "public class Foo {" + CPD.EOL + " public int BAR = 42;" + CPD.EOL + "}";
    private static final String TEST4 = "public class Foo {" + CPD.EOL + " public final String BAR = \"42\";" + CPD.EOL + "}";
    private static final String TEST5 = "public class Foo {" + CPD.EOL + " public final Thread BAR = new Thread();" + CPD.EOL + "}";

    public void setUp() {
        this.rule = new XPathRule();
        this.rule.addProperty("xpath", "//FieldDeclaration[@Final='true' and @Static='false']/VariableDeclarator/VariableInitializer/Expression/ConditionalAndExpression/InstanceOfExpression/PrimaryExpression/PrimaryPrefix/Literal");
    }

    public void testAll() {
        this.runTests(new TestDescriptor[]{new TestDescriptor(TEST1, "simple failure case", 1, this.rule), new TestDescriptor(TEST2, "already static, OK", 0, this.rule), new TestDescriptor(TEST3, "non-final, OK", 0, this.rule), new TestDescriptor(TEST4, "non-primitive failure case - only works for String", 1, this.rule), new TestDescriptor(TEST5, "final field that's a thread, OK", 0, this.rule)});
    }
}

