/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import edu.umd.cs.findbugs.anttask.AbstractFindBugsTask;
import edu.umd.cs.findbugs.anttask.DataFile;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class SetBugDatabaseInfoTask
extends AbstractFindBugsTask {
    private File outputFile;
    private String name;
    private String timestamp;
    private String source;
    private String findSource;
    private String suppress;
    private String withMessages;
    private String resetSource;
    private DataFile inputFile;

    public SetBugDatabaseInfoTask() {
        super("edu.umd.cs.findbugs.workflow.SetBugDatabaseInfo");
        this.setFailOnError(true);
    }

    public DataFile createDataFile() {
        if (this.inputFile != null) {
            throw new BuildException("only one dataFile element is allowed", this.getLocation());
        }
        this.inputFile = new DataFile();
        return this.inputFile;
    }

    public void setName(String arg) {
        this.name = arg;
    }

    public void setTimestamp(String arg) {
        this.timestamp = arg;
    }

    public void setOutput(File output) {
        this.outputFile = output;
    }

    public void setInput(String input) {
        this.inputFile = new DataFile();
        this.inputFile.name = input;
    }

    public void setSuppress(String arg) {
        this.suppress = arg;
    }

    public void setSource(String arg) {
        this.source = arg;
    }

    public void setFindSource(String arg) {
        this.findSource = arg;
    }

    public void setWithMessages(String arg) {
        this.withMessages = arg;
    }

    public void setResetSource(String arg) {
        this.resetSource = arg;
    }

    private void checkBoolean(String attrVal, String attrName) {
        if (attrVal == null) {
            return;
        }
        if (!(attrVal = attrVal.toLowerCase()).equals("true") && !attrVal.equals("false")) {
            throw new BuildException("attribute " + attrName + " requires boolean value", this.getLocation());
        }
    }

    protected void checkParameters() {
        super.checkParameters();
        if (this.outputFile == null) {
            throw new BuildException("output attribute is required", this.getLocation());
        }
        if (this.inputFile == null) {
            throw new BuildException("inputFile element is required");
        }
        this.checkBoolean(this.withMessages, "withMessages");
        this.checkBoolean(this.resetSource, "resetSource");
    }

    private void addOption(String name, String value) {
        if (value != null) {
            this.addArg(name);
            this.addArg(value);
        }
    }

    public void addBoolOption(String option, String value) {
        if (value != null) {
            this.addArg(option + ":" + value);
        }
    }

    protected void configureFindbugsEngine() {
        this.addOption("-name", this.name);
        this.addOption("-timestamp", this.timestamp);
        this.addOption("-source", this.source);
        this.addOption("-findSource", this.findSource);
        this.addOption("-suppress", this.suppress);
        this.addBoolOption("-withMessages", this.withMessages);
        if (this.resetSource != null && this.resetSource.equals("true")) {
            this.addArg("-resetSource");
        }
        this.addArg(this.inputFile.getName());
        if (this.outputFile != null) {
            this.addArg(this.outputFile.getAbsolutePath());
        }
    }

    protected void beforeExecuteJavaProcess() {
        this.log("running setBugDatabaseInfo...");
    }

    protected void afterExecuteJavaProcess(int rc) {
        if (rc != 0) {
            throw new BuildException("execution of " + this.getTaskName() + " failed");
        }
    }
}

