/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.EncodingChunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class EncodingChunkReader {
    public static EncodingChunk read(RandomAccessFile raf, Chunk candidate) throws IOException {
        if (raf == null || candidate == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        if (GUID.GUID_ENCODING.equals(candidate.getGuid())) {
            raf.seek(candidate.getPosition());
            return new EncodingChunkReader().parseData(raf);
        }
        return null;
    }

    protected EncodingChunkReader() {
    }

    private EncodingChunk parseData(RandomAccessFile raf) throws IOException {
        EncodingChunk result = null;
        long chunkStart = raf.getFilePointer();
        GUID guid = Utils.readGUID(raf);
        if (GUID.GUID_ENCODING.equals(guid)) {
            BigInteger chunkLen = Utils.readBig64(raf);
            result = new EncodingChunk(chunkStart, chunkLen);
            raf.skipBytes(20);
            int stringCount = Utils.readUINT16(raf);
            int i = 0;
            while (i < stringCount) {
                result.addString(Utils.readCharacterSizedString(raf));
                ++i;
            }
        }
        return result;
    }
}

