/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.jaudiotagger.tag.datatype.AbstractStringStringValuePair;

public abstract class ID3Frames
extends AbstractStringStringValuePair {
    protected TreeSet<String> multipleFrames = new TreeSet();
    protected TreeSet<String> discardIfFileAlteredFrames = new TreeSet();
    protected TreeSet<String> supportedFrames = new TreeSet();
    protected TreeSet<String> extensionFrames = new TreeSet();
    protected TreeSet<String> commonFrames = new TreeSet();
    protected TreeSet<String> binaryFrames = new TreeSet();
    public static final Map<String, String> convertv22Tov23 = new LinkedHashMap<String, String>();
    public static final Map<String, String> convertv23Tov22 = new LinkedHashMap<String, String>();
    public static final Map<String, String> forcev22Tov23 = new LinkedHashMap<String, String>();
    public static final Map<String, String> forcev23Tov22 = new LinkedHashMap<String, String>();
    public static final Map<String, String> convertv23Tov24 = new LinkedHashMap<String, String>();
    public static final Map<String, String> convertv24Tov23 = new LinkedHashMap<String, String>();
    public static final Map<String, String> forcev23Tov24 = new LinkedHashMap<String, String>();
    public static final Map<String, String> forcev24Tov23 = new LinkedHashMap<String, String>();

    static {
        ID3Frames.loadID3v22ID3v23Mapping();
        ID3Frames.loadID3v23ID3v24Mapping();
    }

    public boolean isDiscardIfFileAltered(String frameID) {
        return this.discardIfFileAlteredFrames.contains(frameID);
    }

    public boolean isMultipleAllowed(String frameID) {
        return this.multipleFrames.contains(frameID);
    }

    public boolean isSupportedFrames(String frameID) {
        return this.supportedFrames.contains(frameID);
    }

    public boolean isCommon(String frameID) {
        return this.commonFrames.contains(frameID);
    }

    public boolean isBinary(String frameID) {
        return this.binaryFrames.contains(frameID);
    }

    public boolean isExtensionFrames(String frameID) {
        return this.extensionFrames.contains(frameID);
    }

    private static void loadID3v23ID3v24Mapping() {
        convertv23Tov24.put("XSOT", "TSOT");
        convertv23Tov24.put("XSOP", "TSOP");
        convertv23Tov24.put("XSOA", "TSOA");
        forcev23Tov24.put("RVAD", "RVA2");
        forcev23Tov24.put("EQUA", "EQU2");
        forcev23Tov24.put("IPLS", "TIPL");
        forcev23Tov24.put("TDAT", "TDRC");
        forcev23Tov24.put("TIME", "TDRC");
        forcev23Tov24.put("TORY", "TDOR");
        forcev23Tov24.put("TRDA", "TDRC");
        forcev23Tov24.put("TYER", "TDRC");
        forcev24Tov23.put("RVA2", "RVAD");
        forcev24Tov23.put("TIPL", "IPLS");
    }

    private static void loadID3v22ID3v23Mapping() {
        convertv22Tov23.put("TP2", "TPE2");
        convertv22Tov23.put("TAL", "TALB");
        convertv22Tov23.put("TP1", "TPE1");
        convertv22Tov23.put("CRA", "AENC");
        convertv22Tov23.put("TBP", "TBPM");
        convertv22Tov23.put("COM", "COMM");
        convertv22Tov23.put("COM", "COMM");
        convertv22Tov23.put("TCM", "TCOM");
        convertv22Tov23.put("TPE", "TPE3");
        convertv22Tov23.put("TT1", "TIT1");
        convertv22Tov23.put("TCR", "TCOP");
        convertv22Tov23.put("TEN", "TENC");
        convertv22Tov23.put("EQU", "EQUA");
        convertv22Tov23.put("ETC", "ETCO");
        convertv22Tov23.put("TFT", "TFLT");
        convertv22Tov23.put("GEO", "GEOB");
        convertv22Tov23.put("TCO", "TCON");
        convertv22Tov23.put("TSS", "TSSE");
        convertv22Tov23.put("TKE", "TKEY");
        convertv22Tov23.put("IPL", "IPLS");
        convertv22Tov23.put("TRC", "TSRC");
        convertv22Tov23.put("TLA", "TLAN");
        convertv22Tov23.put("TLE", "TLEN");
        convertv22Tov23.put("LNK", "LINK");
        convertv22Tov23.put("TXT", "TEXT");
        convertv22Tov23.put("TMT", "TMED");
        convertv22Tov23.put("MLL", "MLLT");
        convertv22Tov23.put("MCI", "MCDI");
        convertv22Tov23.put("TOA", "TOPE");
        convertv22Tov23.put("TOF", "TOFN");
        convertv22Tov23.put("TOL", "TOLY");
        convertv22Tov23.put("TOT", "TOAL");
        convertv22Tov23.put("TDY", "TDLY");
        convertv22Tov23.put("CNT", "PCNT");
        convertv22Tov23.put("CNT", "PCNT");
        convertv22Tov23.put("POP", "POPM");
        convertv22Tov23.put("TPB", "TPUB");
        convertv22Tov23.put("BUF", "RBUF");
        convertv22Tov23.put("BUF", "RBUF");
        convertv22Tov23.put("RVA", "RVAD");
        convertv22Tov23.put("TP4", "TPE4");
        convertv22Tov23.put("REV", "RVRB");
        convertv22Tov23.put("TPA", "TPOS");
        convertv22Tov23.put("SLT", "SYLT");
        convertv22Tov23.put("STC", "SYTC");
        convertv22Tov23.put("TDA", "TDAT");
        convertv22Tov23.put("TIM", "TIME");
        convertv22Tov23.put("TT3", "TIT3");
        convertv22Tov23.put("TOR", "TORY");
        convertv22Tov23.put("TRK", "TRCK");
        convertv22Tov23.put("TRD", "TRDA");
        convertv22Tov23.put("TSI", "TSIZ");
        convertv22Tov23.put("TYE", "TYER");
        convertv22Tov23.put("UFI", "UFID");
        convertv22Tov23.put("UFI", "UFID");
        convertv22Tov23.put("ULT", "USLT");
        convertv22Tov23.put("WAR", "WOAR");
        convertv22Tov23.put("WCM", "WCOM");
        convertv22Tov23.put("WCP", "WCOP");
        convertv22Tov23.put("WAF", "WOAF");
        convertv22Tov23.put("WRS", "WORS");
        convertv22Tov23.put("WPAY", "WPAY");
        convertv22Tov23.put("WPB", "WPUB");
        convertv22Tov23.put("WAS", "WOAS");
        convertv22Tov23.put("TXX", "TXXX");
        convertv22Tov23.put("WXX", "WXXX");
        convertv22Tov23.put("TT2", "TIT2");
        convertv22Tov23.put("TCP", "TCMP");
        convertv22Tov23.put("TST", "TSOT");
        convertv22Tov23.put("TSP", "TSOP");
        convertv22Tov23.put("TSA", "TSOA");
        convertv22Tov23.put("TS2", "TSO2");
        convertv22Tov23.put("TSC", "TSOC");
        for (String key : convertv22Tov23.keySet()) {
            String value = convertv22Tov23.get(key);
            convertv23Tov22.put(value, key);
        }
        convertv23Tov22.put("XSOT", "TST");
        convertv23Tov22.put("XSOP", "TSP");
        convertv23Tov22.put("XSOA", "TSA");
        forcev22Tov23.put("PIC", "APIC");
        forcev23Tov22.put("APIC", "PIC");
    }
}

