/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.plaf.common;

import com.jgoodies.plaf.common.MenuItemRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;

public class ExtBasicMenuUI
extends BasicMenuUI {
    private static final String MENU_PROPERTY_PREFIX = "Menu";
    private static final String SUBMENU_PROPERTY_PREFIX = "MenuItem";
    private String propertyPrefix = "Menu";
    private MenuItemRenderer renderer;
    private MouseListener mouseListener;

    public static ComponentUI createUI(JComponent b) {
        return new ExtBasicMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        }
        this.renderer = new MenuItemRenderer(this.menuItem, false, this.acceleratorFont, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
        Integer gap = (Integer)UIManager.get(this.getPropertyPrefix() + ".textIconGap");
        this.defaultTextIconGap = gap != null ? gap : 2;
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.renderer = null;
    }

    protected String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon aCheckIcon, Icon anArrowIcon, int textIconGap) {
        if (this.isSubMenu(this.menuItem)) {
            this.ensureSubMenuInstalled();
            return this.renderer.getPreferredMenuItemSize(c, aCheckIcon, anArrowIcon, textIconGap);
        }
        return super.getPreferredMenuItemSize(c, aCheckIcon, anArrowIcon, textIconGap);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon aCheckIcon, Icon anArrowIcon, Color background, Color foreground, int textIconGap) {
        if (this.isSubMenu(this.menuItem)) {
            this.renderer.paintMenuItem(g, c, aCheckIcon, anArrowIcon, background, foreground, textIconGap);
        } else {
            super.paintMenuItem(g, c, aCheckIcon, anArrowIcon, background, foreground, textIconGap);
        }
    }

    private void ensureSubMenuInstalled() {
        if (this.propertyPrefix.equals(SUBMENU_PROPERTY_PREFIX)) {
            return;
        }
        this.uninstallRolloverListener();
        this.uninstallDefaults();
        this.propertyPrefix = SUBMENU_PROPERTY_PREFIX;
        this.installDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        this.mouseListener = this.createRolloverListener();
        this.menuItem.addMouseListener(this.mouseListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.uninstallRolloverListener();
    }

    private void uninstallRolloverListener() {
        if (this.mouseListener != null) {
            this.menuItem.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    protected MouseListener createRolloverListener() {
        return new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                AbstractButton b = (AbstractButton)e.getSource();
                b.getModel().setRollover(true);
            }

            public void mouseExited(MouseEvent e) {
                AbstractButton b = (AbstractButton)e.getSource();
                b.getModel().setRollover(false);
            }
        };
    }

    private boolean isSubMenu(JMenuItem aMenuItem) {
        return !((JMenu)aMenuItem).isTopLevelMenu();
    }
}

