/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class Browser
extends Composite {
    WebBrowser webBrowser;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.browser.";
    static final String NO_INPUT_METHOD = "org.eclipse.swt.internal.gtk.noInputMethod";

    public Browser(Composite parent, int style) {
        super(Browser.checkParent(parent), Browser.checkStyle(style));
        String platform = SWT.getPlatform();
        Display display = parent.getDisplay();
        if ("gtk".equals(platform)) {
            display.setData(NO_INPUT_METHOD, null);
        }
        String className = null;
        if ((style & 0x8000) != 0) {
            className = "org.eclipse.swt.browser.Mozilla";
        } else if ("win32".equals(platform) || "wpf".equals(platform)) {
            className = "org.eclipse.swt.browser.IE";
        } else if ("motif".equals(platform)) {
            className = "org.eclipse.swt.browser.Mozilla";
        } else if ("gtk".equals(platform)) {
            className = "org.eclipse.swt.browser.Mozilla";
        } else if ("carbon".equals(platform)) {
            className = "org.eclipse.swt.browser.Safari";
        } else if ("photon".equals(platform)) {
            className = "org.eclipse.swt.browser.Voyager";
        } else {
            this.dispose();
            SWT.error(2);
        }
        try {
            Class<?> clazz = Class.forName(className);
            this.webBrowser = (WebBrowser)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        if (this.webBrowser == null) {
            this.dispose();
            SWT.error(2);
        }
        this.webBrowser.setBrowser(this);
        this.webBrowser.create(parent, style);
    }

    static Composite checkParent(Composite parent) {
        Display display;
        String platform = SWT.getPlatform();
        if (!"gtk".equals(platform)) {
            return parent;
        }
        if (parent != null && !parent.isDisposed() && (display = parent.getDisplay()) != null && display.getThread() == Thread.currentThread()) {
            display.setData(NO_INPUT_METHOD, "true");
        }
        return parent;
    }

    static int checkStyle(int style) {
        String platform = SWT.getPlatform();
        if ((style & 0x8000) != 0) {
            if ("carbon".equals(platform)) {
                return style | 0x1000000;
            }
            if ("motif".equals(platform)) {
                return style | 0x1000000;
            }
            return style;
        }
        if ("win32".equals(platform)) {
            return style & 0xFFFFF7FF;
        }
        if ("motif".equals(platform)) {
            return style | 0x1000000;
        }
        return style;
    }

    public static void clearSessions() {
        WebBrowser.clearSessions();
    }

    public void addCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.addCloseWindowListener(listener);
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.addLocationListener(listener);
    }

    public void addOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.addOpenWindowListener(listener);
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.addProgressListener(listener);
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.addStatusTextListener(listener);
    }

    public void addTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.addTitleListener(listener);
    }

    public void addVisibilityWindowListener(VisibilityWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.addVisibilityWindowListener(listener);
    }

    public boolean back() {
        this.checkWidget();
        return this.webBrowser.back();
    }

    protected void checkSubclass() {
        int index;
        String name = this.getClass().getName();
        if (!name.substring(0, (index = name.lastIndexOf(46)) + 1).equals(PACKAGE_PREFIX)) {
            SWT.error(43);
        }
    }

    public boolean execute(String script) {
        this.checkWidget();
        if (script == null) {
            SWT.error(4);
        }
        return this.webBrowser.execute(script);
    }

    public boolean forward() {
        this.checkWidget();
        return this.webBrowser.forward();
    }

    public String getUrl() {
        this.checkWidget();
        return this.webBrowser.getUrl();
    }

    public Object getWebBrowser() {
        this.checkWidget();
        return this.webBrowser.getWebBrowser();
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        return this.webBrowser.isBackEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.webBrowser.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        return this.webBrowser.isForwardEnabled();
    }

    public void refresh() {
        this.checkWidget();
        this.webBrowser.refresh();
    }

    public void removeCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeCloseWindowListener(listener);
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeLocationListener(listener);
    }

    public void removeOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeOpenWindowListener(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeProgressListener(listener);
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeStatusTextListener(listener);
    }

    public void removeTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeTitleListener(listener);
    }

    public void removeVisibilityWindowListener(VisibilityWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeVisibilityWindowListener(listener);
    }

    public boolean setText(String html) {
        this.checkWidget();
        if (html == null) {
            SWT.error(4);
        }
        return this.webBrowser.setText(html);
    }

    public boolean setUrl(String url) {
        this.checkWidget();
        if (url == null) {
            SWT.error(4);
        }
        return this.webBrowser.setUrl(url);
    }

    public void stop() {
        this.checkWidget();
        this.webBrowser.stop();
    }
}

