/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.Playlist;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import de.kapsi.net.daap.Txn;
import de.kapsi.net.daap.chunks.impl.HasChildContainers;
import de.kapsi.net.daap.chunks.impl.ParentContainerId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Folder
extends Playlist {
    private final ParentContainerId parentContainerId = new ParentContainerId();
    private HasChildContainers hasChildContainers = new HasChildContainers(true);
    private List<Playlist> playlists = null;

    protected Folder(Playlist playlist, Transaction txn) {
        super(playlist, txn);
        this.parentContainerId.setValue(this.getItemId());
        this.playlists = ((Folder)playlist).playlists;
        this.init();
    }

    public Folder(String name) {
        super(name);
        this.parentContainerId.setValue(this.getItemId());
        this.init();
    }

    private void init() {
        this.addChunk(this.hasChildContainers);
    }

    @Override
    public void addSong(Transaction txn, Song song) {
        throw new UnsupportedOperationException("Songs cannot be added to Folders");
    }

    @Override
    public void removeSong(Transaction txn, Song song) {
        throw new UnsupportedOperationException("Songs cannot be removed from Folders");
    }

    @Override
    public boolean containsSong(Song song) {
        return false;
    }

    @Override
    public int getSongCount() {
        return 0;
    }

    @Override
    public List<Song> getSongs() {
        return Collections.emptyList();
    }

    public void addPlaylist(Transaction txn, final Playlist playlist) {
        if (playlist instanceof Folder) {
            throw new IllegalArgumentException("Recursion is not supported");
        }
        if (txn != null) {
            txn.addTxn(this, new Txn(){

                public void commit(Transaction txn) {
                    Folder.this.addPlaylistP(txn, playlist);
                }
            });
            txn.attach(playlist);
        } else {
            this.addPlaylistP(txn, playlist);
        }
    }

    private void addPlaylistP(Transaction txn, Playlist playlist) {
        if (this.playlists == null) {
            this.playlists = new ArrayList<Playlist>();
        }
        if (!this.containsPlaylist(playlist) && this.playlists.add(playlist)) {
            playlist.addChunk(this.parentContainerId);
        }
    }

    public void removePlaylist(Transaction txn, final Playlist playlist) {
        if (playlist instanceof Folder) {
            return;
        }
        if (txn != null) {
            txn.addTxn(this, new Txn(){

                public void commit(Transaction txn) {
                    Folder.this.removePlaylistP(txn, playlist);
                }
            });
            txn.attach(playlist);
        } else {
            this.removePlaylistP(txn, playlist);
        }
    }

    private void removePlaylistP(Transaction txn, Playlist playlist) {
        if (this.playlists == null) {
            return;
        }
        if (this.playlists.remove(playlist)) {
            playlist.removeChunk(this.parentContainerId);
            if (this.playlists.isEmpty()) {
                this.playlists = null;
            }
        }
    }

    public int getPlaylistCount() {
        return this.getPlaylists().size();
    }

    public List getPlaylists() {
        if (this.playlists != null) {
            return Collections.unmodifiableList(this.playlists);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean containsPlaylist(Playlist playlist) {
        return this.getPlaylists().contains(playlist);
    }
}

