/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.chunks.AbstractChunk;
import de.kapsi.net.daap.chunks.LongChunk;
import java.math.BigInteger;

public abstract class ULongChunk
extends AbstractChunk
implements LongChunk {
    public static final String MIN_VALUE = "0";
    public static final String MAX_VALUE = "18446744073709551615";
    protected long value = 0L;

    public ULongChunk(int type, String name, long value) {
        super(type, name);
        this.setValue(value);
    }

    public ULongChunk(String type, String name, long value) {
        super(type, name);
        this.setValue(value);
    }

    public void setValue(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public BigInteger getUnsignedValue() {
        long l = this.getValue();
        byte[] b = new byte[]{0, (byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return new BigInteger(b);
    }

    public int getType() {
        return 7;
    }

    public String toString(int indent) {
        return ULongChunk.indent(indent) + this.name + "(" + this.getContentCodeString() + "; ulong)=" + this.getUnsignedValue();
    }
}

