/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp;

import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.StateVariable;
import org.cybergarage.upnp.xml.ArgumentData;
import org.cybergarage.xml.Node;

public class Argument {
    public static final String ELEM_NAME = "argument";
    public static final String IN = "in";
    public static final String OUT = "out";
    private Node argumentNode;
    private Node serviceNode;
    private static final String NAME = "name";
    private static final String DIRECTION = "direction";
    private static final String RELATED_STATE_VARIABLE = "relatedStateVariable";

    public Node getArgumentNode() {
        return this.argumentNode;
    }

    private Node getServiceNode() {
        return this.serviceNode;
    }

    public Service getService() {
        return new Service(this.getServiceNode());
    }

    public Node getActionNode() {
        Node argumentLinstNode = this.getArgumentNode().getParentNode();
        if (argumentLinstNode == null) {
            return null;
        }
        Node actionNode = argumentLinstNode.getParentNode();
        if (actionNode == null) {
            return null;
        }
        if (!Action.isActionNode(actionNode)) {
            return null;
        }
        return actionNode;
    }

    public Action getAction() {
        return new Action(this.getServiceNode(), this.getActionNode());
    }

    public Argument() {
        this.argumentNode = new Node();
        this.serviceNode = null;
    }

    public Argument(Node servNode, Node argNode) {
        this.serviceNode = servNode;
        this.argumentNode = argNode;
    }

    public Argument(String name, String value) {
        this();
        this.setName(name);
        this.setValue(value);
    }

    public static boolean isArgumentNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    public void setName(String value) {
        this.getArgumentNode().setNode(NAME, value);
    }

    public String getName() {
        return this.getArgumentNode().getNodeValue(NAME);
    }

    public void setDirection(String value) {
        this.getArgumentNode().setNode(DIRECTION, value);
    }

    public String getDirection() {
        return this.getArgumentNode().getNodeValue(DIRECTION);
    }

    public boolean isInDirection() {
        String dir = this.getDirection();
        if (dir == null) {
            return false;
        }
        return dir.equalsIgnoreCase(IN);
    }

    public boolean isOutDirection() {
        return !this.isInDirection();
    }

    public void setRelatedStateVariableName(String value) {
        this.getArgumentNode().setNode(RELATED_STATE_VARIABLE, value);
    }

    public String getRelatedStateVariableName() {
        return this.getArgumentNode().getNodeValue(RELATED_STATE_VARIABLE);
    }

    public StateVariable getRelatedStateVariable() {
        Service service = this.getService();
        if (service == null) {
            return null;
        }
        String relatedStatVarName = this.getRelatedStateVariableName();
        return service.getStateVariable(relatedStatVarName);
    }

    private ArgumentData getArgumentData() {
        Node node = this.getArgumentNode();
        ArgumentData userData = (ArgumentData)node.getUserData();
        if (userData == null) {
            userData = new ArgumentData();
            node.setUserData(userData);
            userData.setNode(node);
        }
        return userData;
    }

    public void setValue(String value) {
        this.getArgumentData().setValue(value);
    }

    public void setValue(int value) {
        this.setValue(Integer.toString(value));
    }

    public String getValue() {
        return this.getArgumentData().getValue();
    }

    public int getIntegerValue() {
        String value = this.getValue();
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

