/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContentDescription;
import org.jaudiotagger.audio.asf.data.EncodingChunk;
import org.jaudiotagger.audio.asf.data.ExtendedContentDescription;
import org.jaudiotagger.audio.asf.data.FileHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamBitratePropertiesChunk;
import org.jaudiotagger.audio.asf.data.StreamChunk;
import org.jaudiotagger.audio.asf.io.ChunkHeaderReader;
import org.jaudiotagger.audio.asf.io.ContentDescriptionReader;
import org.jaudiotagger.audio.asf.io.EncodingChunkReader;
import org.jaudiotagger.audio.asf.io.ExtContentDescReader;
import org.jaudiotagger.audio.asf.io.FileHeaderReader;
import org.jaudiotagger.audio.asf.io.StreamBitratePropertiesReader;
import org.jaudiotagger.audio.asf.io.StreamChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class AsfHeaderReader {
    public static AsfHeader readHeader(RandomAccessFile in) throws IOException {
        AsfHeaderReader reader = new AsfHeaderReader();
        return reader.parseData(in);
    }

    protected AsfHeaderReader() {
    }

    private AsfHeader parseData(RandomAccessFile in) throws IOException {
        AsfHeader result = null;
        long chunkStart = in.getFilePointer();
        GUID possibleGuid = Utils.readGUID(in);
        if (GUID.GUID_HEADER.equals(possibleGuid)) {
            BigInteger chunkLen = Utils.readBig64(in);
            long chunkCount = Utils.readUINT32(in);
            in.skipBytes(2);
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            while (chunkLen.compareTo(BigInteger.valueOf(in.getFilePointer())) > 0) {
                Chunk chunk = ChunkHeaderReader.readChunckHeader(in);
                chunks.add(chunk);
                in.seek(chunk.getChunckEnd());
            }
            result = new AsfHeader(chunkStart, chunkLen, chunkCount);
            FileHeader fileHeader = null;
            ExtendedContentDescription extendedDescription = null;
            EncodingChunk encodingChunk = null;
            StreamChunk streamChunk = null;
            ContentDescription contentDescription = null;
            StreamBitratePropertiesChunk bitratePropertiesChunk = null;
            for (Chunk currentChunk : chunks) {
                if (fileHeader == null && (fileHeader = FileHeaderReader.read(in, currentChunk)) != null || extendedDescription == null && (extendedDescription = ExtContentDescReader.read(in, currentChunk)) != null || encodingChunk == null && (encodingChunk = EncodingChunkReader.read(in, currentChunk)) != null) continue;
                if (streamChunk == null && (streamChunk = StreamChunkReader.read(in, currentChunk)) != null) {
                    result.addStreamChunk(streamChunk);
                    streamChunk = null;
                    continue;
                }
                if (contentDescription == null && (contentDescription = ContentDescriptionReader.read(in, currentChunk)) != null || bitratePropertiesChunk == null && (bitratePropertiesChunk = StreamBitratePropertiesReader.read(in, currentChunk)) != null) continue;
                result.addUnspecifiedChunk(currentChunk);
            }
            result.setFileHeader(fileHeader);
            result.setEncodingChunk(encodingChunk);
            result.setExtendedContentDescription(extendedDescription);
            result.setContentDescription(contentDescription);
            result.setStreamBitratePropertiesChunk(bitratePropertiesChunk);
        }
        return result;
    }
}

