/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.blockmodel;

import edu.uci.ics.jung.algorithms.blockmodel.GraphCollapser;
import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.BipartiteEdge;
import edu.uci.ics.jung.graph.impl.BipartiteGraph;
import edu.uci.ics.jung.graph.impl.BipartiteVertex;
import java.util.Iterator;
import java.util.Set;

public class BipartiteGraphCollapser
extends GraphCollapser {
    protected void createUndirectedEdge(Graph g, GraphCollapser.CollapsedVertex superVertex, Vertex opposite, Set relevantEdges) {
        BipartiteGraph bpg = (BipartiteGraph)g;
        BipartiteVertex op = (BipartiteVertex)opposite;
        BipartiteVertex su = (BipartiteVertex)((Object)superVertex);
        CollapsedBipartiteEdge bpe = bpg.getPartition(su) == BipartiteGraph.CLASSA ? (CollapsedBipartiteEdge)bpg.addBipartiteEdge(new CollapsedBipartiteEdge(su, op, relevantEdges)) : (CollapsedBipartiteEdge)bpg.addBipartiteEdge(new CollapsedBipartiteEdge(op, su, relevantEdges));
        this.annotateEdge(bpe, relevantEdges);
    }

    protected GraphCollapser.CollapsedVertex createCollapsedVertex(Graph g, Set rootSet) {
        BipartiteGraph.Choice choice = null;
        BipartiteGraph bpg = (BipartiteGraph)g;
        Iterator iter = rootSet.iterator();
        while (iter.hasNext()) {
            BipartiteVertex v = (BipartiteVertex)iter.next();
            if (choice == null) {
                choice = bpg.getPartition(v);
                continue;
            }
            if (choice == bpg.getPartition(v)) continue;
            throw new FatalException("All vertices must be in the same partition");
        }
        CollapsedBipartiteVertex cbv = new CollapsedBipartiteVertex(rootSet);
        bpg.addVertex(cbv, choice);
        return cbv;
    }

    public class CollapsedBipartiteVertex
    extends BipartiteVertex
    implements GraphCollapser.CollapsedVertex {
        private Set rootSet;

        public CollapsedBipartiteVertex(Set rootSet) {
            this.rootSet = rootSet;
        }

        public Set getRootSet() {
            return this.rootSet;
        }
    }

    public class CollapsedBipartiteEdge
    extends BipartiteEdge
    implements GraphCollapser.CollapsedEdge {
        private Set relevantEdges;

        public CollapsedBipartiteEdge(BipartiteVertex a, BipartiteVertex b, Set edges) {
            super(a, b);
            this.relevantEdges = edges;
        }

        public Set getRelevantEdges() {
            return this.relevantEdges;
        }
    }
}

